/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidbootstrap.view.animator;

import android.content.Context;
import android.database.DataSetObserver;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.tunjid.androidbootstrap.view.util.ViewUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ViewPagerIndicatorAnimator {
    private static final int MIN_INDICATORS_TO_SHOW = 2;
    private static final int MIN_VIEWS_IN_LAYOUT = 3;
    private int[] chainIds;
    private int indicatorCount;
    private int guideLineWidth;
    private final int indicatorHeight;
    private final int indicatorPadding;
    private final int indicatorWidth;
    @DrawableRes
    private final int inActiveDrawable;
    private final ConstraintLayout container;
    private final ViewPager viewPager;
    private final ImageView indicator;
    private final View guide;
    private Animator animator;
    private final List<IndicatorWatcher> watchers;

    protected ViewPagerIndicatorAnimator(int indicatorWidth, int indicatorHeight, int indicatorPadding, @DrawableRes int activeDrawable, @DrawableRes int inActiveDrawable, @DrawableRes int backgroundDrawable, ConstraintLayout container, ViewPager viewPager, View guide) {
        this.indicatorWidth = indicatorWidth;
        this.indicatorHeight = indicatorHeight;
        this.inActiveDrawable = inActiveDrawable;
        this.indicatorPadding = indicatorPadding;
        this.container = container;
        this.viewPager = viewPager;
        this.guide = guide;
        this.indicator = this.buildIndicator();
        this.animator = new Animator();
        this.watchers = new ArrayList<IndicatorWatcher>();
        PagerAdapter adapter = viewPager.getAdapter();
        if (adapter != null) {
            this.buildIndicators(adapter);
        }
        Context context = viewPager.getContext();
        if (backgroundDrawable != 0) {
            guide.setBackground(ContextCompat.getDrawable((Context)context, (int)backgroundDrawable));
        }
        if (activeDrawable != 0) {
            this.indicator.setImageResource(activeDrawable);
        }
    }

    public static Builder<ViewPagerIndicatorAnimator> builder() {
        return new SimpleBuilder();
    }

    public ImageView getIndicator() {
        return this.indicator;
    }

    public ImageView getIndicatorAt(int index) {
        return index < 0 || this.chainIds == null || index > this.chainIds.length - 1 ? this.indicator : (ImageView)this.container.findViewById(this.chainIds[index]);
    }

    public void addIndicatorWatcher(IndicatorWatcher watcher) {
        if (!this.watchers.contains(watcher)) {
            this.watchers.add(watcher);
        }
    }

    public void removeIndicatorWatcher(IndicatorWatcher watcher) {
        this.watchers.remove(watcher);
    }

    private ImageView buildIndicator() {
        ImageView result = new ImageView(this.container.getContext());
        result.setId(View.generateViewId());
        ConstraintLayout.LayoutParams params = new ConstraintLayout.LayoutParams(this.indicatorWidth, this.indicatorHeight);
        params.rightMargin = params.leftMargin = this.indicatorPadding;
        params.bottomToBottom = this.guide.getId();
        this.container.addView((View)result, (ViewGroup.LayoutParams)params);
        return result;
    }

    private void buildIndicators(@Nullable PagerAdapter newAdapter) {
        if (newAdapter == null) {
            return;
        }
        int pageCount = newAdapter.getCount();
        if (this.container.getChildCount() > 3) {
            this.container.removeViews(3, this.indicatorCount);
        }
        if (pageCount < 2) {
            this.indicator.setVisibility(8);
            return;
        }
        this.chainIds = new int[pageCount];
        this.indicatorCount = 0;
        this.indicator.setVisibility(0);
        while (this.indicatorCount < pageCount) {
            ImageView imageView = this.buildIndicator();
            this.chainIds[this.indicatorCount] = imageView.getId();
            imageView.setImageResource(this.inActiveDrawable);
            ++this.indicatorCount;
        }
        int guideId = this.guide.getId();
        int indicatorId = this.indicator.getId();
        ViewUtil.getLayoutParams((View)this.guide).width = pageCount * (this.indicatorWidth + this.indicatorPadding * 2);
        ConstraintSet set = new ConstraintSet();
        set.clone(this.container);
        set.createHorizontalChain(guideId, 1, guideId, 2, this.chainIds, null, 2);
        set.connect(indicatorId, 1, guideId, 1);
        set.connect(this.chainIds[0], 1, guideId, 1);
        set.connect(this.chainIds[pageCount - 1], 2, guideId, 2);
        set.applyTo(this.container);
        this.container.bringChildToFront((View)this.indicator);
        ViewTreeObserver observer = this.guide.getViewTreeObserver();
        if (observer.isAlive()) {
            observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.animator);
            this.guide.invalidate();
        }
    }

    @FunctionalInterface
    public static interface IndicatorWatcher {
        public void onIndicatorMoved(ImageView var1, int var2, float var3, float var4);
    }

    private static class SimpleBuilder
    extends Builder<ViewPagerIndicatorAnimator> {
        private SimpleBuilder() {
        }

        @Override
        public ViewPagerIndicatorAnimator build() {
            if (this.container == null) {
                throw new NullPointerException("ConstraintLayout is null");
            }
            if (this.viewPager == null) {
                throw new NullPointerException("ViewPager is null");
            }
            if (this.guideLine == null) {
                throw new NullPointerException("Guide is null");
            }
            if (!this.container.equals(this.guideLine.getParent())) {
                throw new IllegalArgumentException("Guideline must be child of ConstraintLayout");
            }
            return new ViewPagerIndicatorAnimator(this.indicatorWidth, this.indicatorHeight, this.indicatorPadding, this.activeDrawable, this.inActiveDrawable, this.backgroundDrawable, this.container, this.viewPager, this.guideLine);
        }
    }

    public static abstract class Builder<T extends ViewPagerIndicatorAnimator> {
        int indicatorWidth;
        int indicatorHeight;
        int indicatorPadding;
        int activeDrawable;
        int inActiveDrawable;
        int backgroundDrawable;
        ConstraintLayout container;
        ViewPager viewPager;
        View guideLine;

        public Builder<T> setIndicatorWidth(int indicatorWidth) {
            this.indicatorWidth = indicatorWidth;
            return this;
        }

        public Builder<T> setIndicatorHeight(int indicatorHeight) {
            this.indicatorHeight = indicatorHeight;
            return this;
        }

        public Builder<T> setIndicatorPadding(int indicatorPadding) {
            this.indicatorPadding = indicatorPadding;
            return this;
        }

        public Builder<T> setActiveDrawable(int activeDrawable) {
            this.activeDrawable = activeDrawable;
            return this;
        }

        public Builder<T> setInActiveDrawable(int inActiveDrawable) {
            this.inActiveDrawable = inActiveDrawable;
            return this;
        }

        public Builder<T> setBackgroundDrawable(int backgroundDrawable) {
            this.backgroundDrawable = backgroundDrawable;
            return this;
        }

        public Builder<T> setContainer(ConstraintLayout container) {
            this.container = container;
            return this;
        }

        public Builder<T> setViewPager(ViewPager viewPager) {
            this.viewPager = viewPager;
            return this;
        }

        public Builder<T> setGuideLine(View guideLine) {
            this.guideLine = guideLine;
            return this;
        }

        public abstract T build();
    }

    private class Animator
    extends DataSetObserver
    implements ViewPager.OnPageChangeListener,
    ViewPager.OnAdapterChangeListener,
    ViewTreeObserver.OnGlobalLayoutListener {
        private float lastPositionOffset;

        private Animator() {
            PagerAdapter adapter = ViewPagerIndicatorAnimator.this.viewPager.getAdapter();
            if (adapter != null) {
                adapter.registerDataSetObserver((DataSetObserver)this);
            }
            ViewPagerIndicatorAnimator.this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            ViewPagerIndicatorAnimator.this.viewPager.addOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this);
        }

        public void onAdapterChanged(@NonNull ViewPager viewPager, @Nullable PagerAdapter oldAdapter, @Nullable PagerAdapter newAdapter) {
            if (newAdapter == null) {
                return;
            }
            newAdapter.registerDataSetObserver((DataSetObserver)this);
            ViewPagerIndicatorAnimator.this.buildIndicators(newAdapter);
        }

        public void onPageScrolled(int position, float fraction, int pixelOffset) {
            float currentPositionOffset = (float)position + fraction;
            boolean toTheRight = currentPositionOffset > this.lastPositionOffset;
            this.onMoved(toTheRight, toTheRight ? position : position + 1, fraction);
            this.lastPositionOffset = currentPositionOffset;
        }

        public void onGlobalLayout() {
            ViewTreeObserver observer = ViewPagerIndicatorAnimator.this.guide.getViewTreeObserver();
            if (observer.isAlive()) {
                observer.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            ViewPagerIndicatorAnimator.this.guideLineWidth = ViewPagerIndicatorAnimator.this.guide.getWidth();
            this.onMoved(false, ViewPagerIndicatorAnimator.this.viewPager.getCurrentItem() + 1, 0.0f);
        }

        private float getTranslation(boolean toTheRight, int originalPosition, float fraction) {
            if (!toTheRight) {
                fraction = 1.0f - fraction;
            }
            float chunkWidth = (float)ViewPagerIndicatorAnimator.this.guideLineWidth / (float)Objects.requireNonNull(ViewPagerIndicatorAnimator.this.viewPager.getAdapter()).getCount();
            float currentChunk = (float)originalPosition * chunkWidth;
            float diff = chunkWidth * fraction;
            return toTheRight ? currentChunk + diff : currentChunk - diff;
        }

        private void onMoved(boolean toTheRight, int position, float fraction) {
            float translation = this.getTranslation(toTheRight, position, fraction);
            ViewPagerIndicatorAnimator.this.indicator.setTranslationX(translation);
            for (int i = ViewPagerIndicatorAnimator.this.watchers.size() - 1; i >= 0; --i) {
                ((IndicatorWatcher)ViewPagerIndicatorAnimator.this.watchers.get(i)).onIndicatorMoved(ViewPagerIndicatorAnimator.this.indicator, position, fraction, translation);
            }
        }

        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
        }
    }
}

