/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidbootstrap.view.animator;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.transition.AutoTransition;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.ripple.RippleUtils;
import com.tunjid.androidbootstrap.view.R;
import com.tunjid.androidbootstrap.view.util.ViewUtil;
import java.util.Objects;

public class FabExtensionAnimator {
    private static final float TWITCH_END = 20.0f;
    private static final float TWITCH_START = 0.0f;
    private static final int TWITCH_DURATION = 200;
    private static final int EXTENSION_DURATION = 150;
    private static final String ROTATION_Y_PROPERTY = "rotationY";
    private final int collapsedFabSize;
    private final int extendedFabHeight;
    private boolean isAnimating;
    private GlyphState glyphState;
    private final MaterialButton button;
    private final Transition.TransitionListener listener = new Transition.TransitionListener(){

        public void onTransitionStart(Transition transition) {
            FabExtensionAnimator.this.isAnimating = true;
        }

        public void onTransitionEnd(Transition transition) {
            FabExtensionAnimator.this.isAnimating = false;
        }

        public void onTransitionCancel(Transition transition) {
            FabExtensionAnimator.this.isAnimating = false;
        }

        public void onTransitionPause(Transition transition) {
        }

        public void onTransitionResume(Transition transition) {
        }
    };

    public FabExtensionAnimator(MaterialButton button) {
        this.button = button;
        this.collapsedFabSize = button.getResources().getDimensionPixelSize(R.dimen.collapsed_fab_size);
        this.extendedFabHeight = button.getResources().getDimensionPixelSize(R.dimen.extended_fab_height);
        button.setBackground(this.getDrawable());
    }

    public static GlyphState newState(CharSequence text, Drawable icon) {
        return new SimpleGlyphState(text, icon);
    }

    public void updateGlyphs(@NonNull GlyphState glyphState) {
        boolean isSame = glyphState.equals(this.glyphState);
        this.glyphState = glyphState;
        this.animateChange(glyphState, isSame);
    }

    public void setExtended(boolean extended) {
        this.setExtended(extended, false);
    }

    public boolean isExtended() {
        ViewGroup.MarginLayoutParams params = ViewUtil.getLayoutParams((View)this.button);
        return params.height != params.width || params.width != this.getCollapsedFabSize();
    }

    private void animateChange(GlyphState glyphState, boolean isSame) {
        boolean extended = this.isExtended();
        this.button.setText(glyphState.getText());
        this.button.setIcon(glyphState.getIcon());
        this.setExtended(extended, !isSame);
        if (!extended) {
            this.onPreExtend();
        }
    }

    private void setExtended(boolean extended, boolean force) {
        if (this.isAnimating || extended && this.isExtended() && !force) {
            return;
        }
        int collapsedFabSize = this.getCollapsedFabSize();
        int width = extended ? -2 : collapsedFabSize;
        int height = extended ? this.getExpandedFabHeight() : collapsedFabSize;
        ViewGroup.MarginLayoutParams params = ViewUtil.getLayoutParams((View)this.button);
        ViewGroup group = (ViewGroup)this.button.getParent();
        params.width = width;
        params.height = height;
        TransitionManager.beginDelayedTransition((ViewGroup)group, (Transition)new AutoTransition().setDuration(150L).addListener(this.listener).addTarget((View)this.button));
        if (extended) {
            this.button.setText(this.glyphState.getText());
        } else {
            this.button.setText((CharSequence)"");
        }
        this.button.requestLayout();
        this.button.invalidate();
    }

    public void onPreExtend() {
        AnimatorSet set = new AnimatorSet();
        set.play((Animator)this.animateProperty(20.0f, 0.0f)).after((Animator)this.animateProperty(0.0f, 20.0f));
        set.start();
    }

    protected int getCollapsedFabSize() {
        return this.collapsedFabSize;
    }

    protected int getExpandedFabHeight() {
        return this.extendedFabHeight;
    }

    @NonNull
    private ObjectAnimator animateProperty(float start, float end) {
        return ObjectAnimator.ofFloat((Object)this.button, (String)ROTATION_Y_PROPERTY, (float[])new float[]{start, end}).setDuration(200L);
    }

    @SuppressLint(value={"RestrictedApi"})
    private Drawable getDrawable() {
        int cornerRadius = this.getCollapsedFabSize();
        int strokeWidth = this.button.getStrokeWidth();
        ColorStateList rippleColor = this.button.getRippleColor();
        ColorStateList strokeColor = this.button.getStrokeColor();
        GradientDrawable backgroundDrawable = new GradientDrawable();
        backgroundDrawable.setCornerRadius((float)cornerRadius);
        backgroundDrawable.setColor(-1);
        GradientDrawable strokeDrawable = new GradientDrawable();
        strokeDrawable.setStroke(strokeWidth, strokeColor);
        strokeDrawable.setCornerRadius((float)cornerRadius);
        strokeDrawable.setColor(0);
        GradientDrawable maskDrawable = new GradientDrawable();
        maskDrawable.setCornerRadius((float)cornerRadius);
        maskDrawable.setColor(-1);
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{backgroundDrawable, strokeDrawable});
        return new RippleDrawable(RippleUtils.convertToRippleDrawableColor((ColorStateList)rippleColor), (Drawable)layerDrawable, (Drawable)maskDrawable);
    }

    private static class SimpleGlyphState
    extends GlyphState {
        public Drawable icon;
        public CharSequence text;

        private SimpleGlyphState(CharSequence text, Drawable icon) {
            this.text = text;
            this.icon = icon;
        }

        @Override
        public CharSequence getText() {
            return this.text;
        }

        @Override
        public Drawable getIcon() {
            return this.icon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleGlyphState that = (SimpleGlyphState)o;
            return Objects.equals(this.icon, that.icon) && Objects.equals(this.text, that.text);
        }

        public int hashCode() {
            return Objects.hash(this.icon, this.text);
        }
    }

    public static abstract class GlyphState {
        public abstract Drawable getIcon();

        public abstract CharSequence getText();
    }
}

