/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidbootstrap.view.behavior;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ViewCompat;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.google.android.material.snackbar.Snackbar;
import java.util.List;

public class BottomTransientBarBehavior
extends CoordinatorLayout.Behavior<View> {
    private static final Interpolator fastOutSlowInInterpolator = new FastOutSlowInInterpolator();

    public BottomTransientBarBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean layoutDependsOn(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull View dependency) {
        return dependency instanceof Snackbar.SnackbarLayout;
    }

    public boolean onDependentViewChanged(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull View dependency) {
        if (child.getVisibility() == 0) {
            float translationY = this.getViewTranslationYForSnackbar(parent, child);
            child.setTranslationY(translationY);
        }
        return true;
    }

    public void onDependentViewRemoved(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull View dependency) {
        if (dependency instanceof Snackbar.SnackbarLayout && child.getTranslationY() != 0.0f) {
            ViewCompat.animate((View)child).translationY(0.0f).scaleX(1.0f).scaleY(1.0f).alpha(1.0f).setInterpolator(fastOutSlowInInterpolator);
        }
    }

    private float getViewTranslationYForSnackbar(CoordinatorLayout parent, View child) {
        float minOffset = 0.0f;
        List dependencies = parent.getDependencies(child);
        int z = dependencies.size();
        for (int i = 0; i < z; ++i) {
            View view = (View)dependencies.get(i);
            if (!(view instanceof Snackbar.SnackbarLayout) || !parent.doViewsOverlap(child, view)) continue;
            minOffset = Math.min(minOffset, view.getTranslationY() - (float)view.getHeight());
        }
        return minOffset;
    }
}

