/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidbootstrap.communications.nsd;

import android.content.Context;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;

public class NsdHelper {
    private static final String TAG = NsdHelper.class.getSimpleName();
    private static final String SERVICE_TYPE = "_http._tcp.";
    private final NsdManager nsdManager;
    private final Consumer<String> stopDiscoveryConsumer;
    private final Consumer<String> startDiscoveryConsumer;
    private final Consumer<NsdServiceInfo> serviceLostConsumer;
    private final Consumer<NsdServiceInfo> serviceFoundConsumer;
    private final Consumer<NsdServiceInfo> resolveSuccessConsumer;
    private final Consumer<NsdServiceInfo> registerSuccessConsumer;
    private final Consumer<NsdServiceInfo> unregisterSuccessConsumer;
    private final BiConsumer<String, Integer> stopDiscoveryErrorConsumer;
    private final BiConsumer<String, Integer> startDiscoveryErrorConsumer;
    private final BiConsumer<NsdServiceInfo, Integer> resolveErrorConsumer;
    private final BiConsumer<NsdServiceInfo, Integer> registerErrorConsumer;
    private final BiConsumer<NsdServiceInfo, Integer> unregisterErrorConsumer;
    private final Set<NsdManager.DiscoveryListener> discoveryListeners = new HashSet<NsdManager.DiscoveryListener>();
    private final Set<NsdManager.RegistrationListener> registrationListeners = new HashSet<NsdManager.RegistrationListener>();

    private NsdHelper(Context context, @Nullable Consumer<String> stopDiscoveryConsumer, @Nullable Consumer<String> startDiscoveryConsumer, @Nullable Consumer<NsdServiceInfo> serviceLostConsumer, @Nullable Consumer<NsdServiceInfo> serviceFoundConsumer, @Nullable Consumer<NsdServiceInfo> resolveSuccessConsumer, @Nullable Consumer<NsdServiceInfo> registerSuccessConsumer, @Nullable Consumer<NsdServiceInfo> unregisterSuccessConsumer, @Nullable BiConsumer<String, Integer> stopDiscoveryErrorConsumer, @Nullable BiConsumer<String, Integer> startDiscoveryErrorConsumer, @Nullable BiConsumer<NsdServiceInfo, Integer> resolveErrorConsumer, @Nullable BiConsumer<NsdServiceInfo, Integer> registerErrorConsumer, @Nullable BiConsumer<NsdServiceInfo, Integer> unregisterErrorConsumer) {
        this.nsdManager = (NsdManager)context.getSystemService("servicediscovery");
        this.stopDiscoveryConsumer = this.orNull(stopDiscoveryConsumer);
        this.startDiscoveryConsumer = this.orNull(startDiscoveryConsumer);
        this.serviceLostConsumer = this.orNull(serviceLostConsumer);
        this.serviceFoundConsumer = this.orNull(serviceFoundConsumer);
        this.resolveSuccessConsumer = this.orNull(resolveSuccessConsumer);
        this.registerSuccessConsumer = this.orNull(registerSuccessConsumer);
        this.unregisterSuccessConsumer = this.orNull(unregisterSuccessConsumer);
        this.resolveErrorConsumer = this.orNull(resolveErrorConsumer);
        this.registerErrorConsumer = this.orNull(registerErrorConsumer);
        this.unregisterErrorConsumer = this.orNull(unregisterErrorConsumer);
        this.stopDiscoveryErrorConsumer = this.orNull(stopDiscoveryErrorConsumer);
        this.startDiscoveryErrorConsumer = this.orNull(startDiscoveryErrorConsumer);
    }

    public static Builder getBuilder(Context context) {
        return new Builder(context);
    }

    public NsdManager getNsdManager() {
        return this.nsdManager;
    }

    public void registerService(int port, String serviceName) {
        NsdServiceInfo serviceInfo = new NsdServiceInfo();
        serviceInfo.setPort(port);
        serviceInfo.setServiceName(serviceName);
        serviceInfo.setServiceType(SERVICE_TYPE);
        this.nsdManager.registerService(serviceInfo, 1, this.getRegistrationListener());
    }

    public void discoverServices() {
        this.stopServiceDiscovery();
        this.nsdManager.discoverServices(SERVICE_TYPE, 1, this.getDiscoveryListener());
    }

    public void resolveService(NsdServiceInfo serviceInfo) {
        this.nsdManager.resolveService(serviceInfo, this.getResolveListener());
    }

    public void stopServiceDiscovery() {
        for (NsdManager.DiscoveryListener listener : this.discoveryListeners) {
            try {
                this.nsdManager.stopServiceDiscovery(listener);
            }
            catch (IllegalArgumentException e) {
                Log.w((String)TAG, (String)"Discovery listener not added");
            }
        }
        this.discoveryListeners.clear();
    }

    private void unregisterService() {
        for (NsdManager.RegistrationListener listener : this.registrationListeners) {
            try {
                this.nsdManager.unregisterService(listener);
            }
            catch (IllegalArgumentException e) {
                Log.w((String)TAG, (String)"Registration listener not added");
            }
        }
        this.registrationListeners.clear();
    }

    public void tearDown() {
        this.stopServiceDiscovery();
        this.unregisterService();
    }

    private <T> Consumer<T> orNull(@Nullable Consumer<T> source) {
        return source == null ? ignored -> {} : source;
    }

    private <T, R> BiConsumer<T, R> orNull(@Nullable BiConsumer<T, R> source) {
        return source == null ? (ignoredA, ignoredB) -> {} : source;
    }

    @NonNull
    private NsdManager.ResolveListener getResolveListener() {
        return new NsdManager.ResolveListener(){

            public void onResolveFailed(NsdServiceInfo serviceInfo, int errorCode) {
                NsdHelper.this.resolveErrorConsumer.accept(serviceInfo, errorCode);
                Log.w((String)TAG, (String)String.format("Failed to resolve service\n%1$s\nwith code %2$d", serviceInfo, errorCode));
            }

            public void onServiceResolved(NsdServiceInfo serviceInfo) {
                NsdHelper.this.resolveSuccessConsumer.accept(serviceInfo);
                Log.w((String)TAG, (String)("resolved service\n" + serviceInfo));
            }
        };
    }

    private NsdManager.DiscoveryListener getDiscoveryListener() {
        NsdManager.DiscoveryListener listener = new NsdManager.DiscoveryListener(){

            public void onServiceFound(NsdServiceInfo service) {
                NsdHelper.this.serviceFoundConsumer.accept(service);
                Log.w((String)TAG, (String)("Found service\n" + service));
            }

            public void onServiceLost(NsdServiceInfo service) {
                NsdHelper.this.serviceLostConsumer.accept(service);
                Log.w((String)TAG, (String)("Lost service:\n" + service));
            }

            public void onDiscoveryStarted(String regType) {
                NsdHelper.this.startDiscoveryConsumer.accept(regType);
                Log.w((String)TAG, (String)("Service discovery started for " + regType));
            }

            public void onDiscoveryStopped(String serviceType) {
                NsdHelper.this.stopDiscoveryConsumer.accept(serviceType);
                Log.w((String)TAG, (String)("Service discovery stopped for " + serviceType));
            }

            public void onStartDiscoveryFailed(String serviceType, int errorCode) {
                NsdHelper.this.startDiscoveryErrorConsumer.accept(serviceType, errorCode);
                Log.w((String)TAG, (String)String.format("Service discovery start failed for service type\n%1$s\nwith code %2$d", serviceType, errorCode));
            }

            public void onStopDiscoveryFailed(String serviceType, int errorCode) {
                NsdHelper.this.stopDiscoveryErrorConsumer.accept(serviceType, errorCode);
                Log.w((String)TAG, (String)String.format("Service discovery stop failed for service type\n%1$s\nwith code %2$d", serviceType, errorCode));
            }
        };
        this.discoveryListeners.add(listener);
        return listener;
    }

    private NsdManager.RegistrationListener getRegistrationListener() {
        NsdManager.RegistrationListener listener = new NsdManager.RegistrationListener(){

            public void onRegistrationFailed(NsdServiceInfo serviceInfo, int errorCode) {
                NsdHelper.this.registerErrorConsumer.accept(serviceInfo, errorCode);
                Log.w((String)TAG, (String)String.format("Service registration failed for service type\n%1$s\nwith code %2$d", serviceInfo.toString(), errorCode));
            }

            public void onUnregistrationFailed(NsdServiceInfo serviceInfo, int errorCode) {
                NsdHelper.this.unregisterErrorConsumer.accept(serviceInfo, errorCode);
                Log.w((String)TAG, (String)String.format("Service un-registration failed for service type\n%1$s\nwith code %2$d", serviceInfo.toString(), errorCode));
            }

            public void onServiceRegistered(NsdServiceInfo serviceInfo) {
                NsdHelper.this.registerSuccessConsumer.accept(serviceInfo);
                Log.w((String)TAG, (String)("Registered service:\n" + serviceInfo));
            }

            public void onServiceUnregistered(NsdServiceInfo serviceInfo) {
                NsdHelper.this.unregisterSuccessConsumer.accept(serviceInfo);
                Log.w((String)TAG, (String)("Un-registered service:\n" + serviceInfo));
            }
        };
        this.registrationListeners.add(listener);
        return listener;
    }

    public static PrintWriter createPrintWriter(Socket socket) throws IOException {
        return new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
    }

    public static BufferedReader createBufferedReader(Socket socket) throws IOException {
        return new BufferedReader(new InputStreamReader(socket.getInputStream()));
    }

    @FunctionalInterface
    public static interface BiConsumer<T, U> {
        public void accept(T var1, U var2);
    }

    @FunctionalInterface
    public static interface Consumer<T> {
        public void accept(T var1);
    }

    public static final class Builder {
        private Context context;
        private Consumer<String> stopDiscoveryConsumer;
        private Consumer<String> startDiscoveryConsumer;
        private Consumer<NsdServiceInfo> serviceLostConsumer;
        private Consumer<NsdServiceInfo> serviceFoundConsumer;
        private Consumer<NsdServiceInfo> resolveSuccessConsumer;
        private Consumer<NsdServiceInfo> registerSuccessConsumer;
        private Consumer<NsdServiceInfo> unregisterSuccessConsumer;
        private BiConsumer<String, Integer> stopDiscoveryErrorConsumer;
        private BiConsumer<String, Integer> startDiscoveryErrorConsumer;
        private BiConsumer<NsdServiceInfo, Integer> resolveErrorConsumer;
        private BiConsumer<NsdServiceInfo, Integer> registerErrorConsumer;
        private BiConsumer<NsdServiceInfo, Integer> unregisterErrorConsumer;

        private Builder(Context context) {
            this.context = context;
        }

        public Builder with(Context context) {
            return new Builder(context);
        }

        public Builder setStopDiscoveryConsumer(Consumer<String> stopDiscoveryConsumer) {
            this.stopDiscoveryConsumer = stopDiscoveryConsumer;
            return this;
        }

        public Builder setStartDiscoveryConsumer(Consumer<String> startDiscoveryConsumer) {
            this.startDiscoveryConsumer = startDiscoveryConsumer;
            return this;
        }

        public Builder setServiceLostConsumer(Consumer<NsdServiceInfo> serviceLostConsumer) {
            this.serviceLostConsumer = serviceLostConsumer;
            return this;
        }

        public Builder setServiceFoundConsumer(Consumer<NsdServiceInfo> serviceFoundConsumer) {
            this.serviceFoundConsumer = serviceFoundConsumer;
            return this;
        }

        public Builder setResolveSuccessConsumer(Consumer<NsdServiceInfo> resolveSuccessConsumer) {
            this.resolveSuccessConsumer = resolveSuccessConsumer;
            return this;
        }

        public Builder setRegisterSuccessConsumer(Consumer<NsdServiceInfo> registerSuccessConsumer) {
            this.registerSuccessConsumer = registerSuccessConsumer;
            return this;
        }

        public Builder setUnregisterSuccessConsumer(Consumer<NsdServiceInfo> unregisterSuccessConsumer) {
            this.unregisterSuccessConsumer = unregisterSuccessConsumer;
            return this;
        }

        public Builder setStopDiscoveryErrorConsumer(BiConsumer<String, Integer> stopDiscoveryErrorConsumer) {
            this.stopDiscoveryErrorConsumer = stopDiscoveryErrorConsumer;
            return this;
        }

        public Builder setStartDiscoveryErrorConsumer(BiConsumer<String, Integer> startDiscoveryErrorConsumer) {
            this.startDiscoveryErrorConsumer = startDiscoveryErrorConsumer;
            return this;
        }

        public Builder setResolveErrorConsumer(BiConsumer<NsdServiceInfo, Integer> resolveErrorConsumer) {
            this.resolveErrorConsumer = resolveErrorConsumer;
            return this;
        }

        public Builder setRegisterErrorConsumer(BiConsumer<NsdServiceInfo, Integer> registerErrorConsumer) {
            this.registerErrorConsumer = registerErrorConsumer;
            return this;
        }

        public Builder setUnregisterErrorConsumer(BiConsumer<NsdServiceInfo, Integer> unregisterErrorConsumer) {
            this.unregisterErrorConsumer = unregisterErrorConsumer;
            return this;
        }

        public NsdHelper build() {
            return new NsdHelper(this.context, this.stopDiscoveryConsumer, this.startDiscoveryConsumer, this.serviceLostConsumer, this.serviceFoundConsumer, this.resolveSuccessConsumer, this.registerSuccessConsumer, this.unregisterSuccessConsumer, this.stopDiscoveryErrorConsumer, this.startDiscoveryErrorConsumer, this.resolveErrorConsumer, this.registerErrorConsumer, this.unregisterErrorConsumer);
        }
    }
}

