/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidbootstrap.communications.nsd;

import android.content.Context;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.support.annotation.NonNull;
import android.util.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;

public class NsdHelper {
    private static final String TAG = NsdHelper.class.getSimpleName();
    private static final String SERVICE_TYPE = "_http._tcp.";
    private final NsdManager nsdManager;
    private NsdManager.ResolveListener resolveListener;
    private NsdManager.DiscoveryListener discoveryListener;
    private NsdManager.RegistrationListener registrationListener;

    private NsdHelper(Context context) {
        this.nsdManager = (NsdManager)context.getSystemService("servicediscovery");
    }

    public static Builder getBuilder(Context context) {
        return new Builder(context);
    }

    public NsdManager getNsdManager() {
        return this.nsdManager;
    }

    public void registerService(int port, String serviceName) {
        NsdServiceInfo serviceInfo = new NsdServiceInfo();
        serviceInfo.setPort(port);
        serviceInfo.setServiceName(serviceName);
        serviceInfo.setServiceType(SERVICE_TYPE);
        this.nsdManager.registerService(serviceInfo, 1, this.registrationListener);
    }

    public boolean discoverServices() {
        try {
            this.nsdManager.discoverServices(SERVICE_TYPE, 1, this.discoveryListener);
            return true;
        }
        catch (IllegalArgumentException e) {
            Log.w((String)TAG, (String)"Nsd Discovery Listener already added");
            return false;
        }
    }

    public boolean unregisterService() {
        try {
            this.nsdManager.unregisterService(this.registrationListener);
            return true;
        }
        catch (IllegalArgumentException e) {
            Log.w((String)TAG, (String)"Nsd Registration listener not added");
            return false;
        }
    }

    public boolean resolveService(NsdServiceInfo serviceInfo) {
        try {
            this.nsdManager.resolveService(serviceInfo, this.resolveListener);
            return true;
        }
        catch (IllegalArgumentException e) {
            Log.w((String)TAG, (String)"Nsd Discovery Listener already added");
            return false;
        }
    }

    public boolean stopServiceDiscovery() {
        try {
            this.nsdManager.stopServiceDiscovery(this.discoveryListener);
            return true;
        }
        catch (IllegalArgumentException e) {
            Log.w((String)TAG, (String)"Nsd Discovery Listener not added");
            return false;
        }
    }

    public boolean tearDown() {
        this.stopServiceDiscovery();
        try {
            this.nsdManager.unregisterService(this.registrationListener);
            return true;
        }
        catch (IllegalArgumentException e) {
            Log.w((String)TAG, (String)"Nsd Registration Listener not added");
            return false;
        }
    }

    public static PrintWriter createPrintWriter(Socket socket) throws IOException {
        return new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
    }

    public static BufferedReader createBufferedReader(Socket socket) throws IOException {
        return new BufferedReader(new InputStreamReader(socket.getInputStream()));
    }

    public static final class Builder {
        private NsdHelper nsdHelper;

        private Builder(Context context) {
            this.nsdHelper = new NsdHelper(context);
        }

        public Builder with(Context context) {
            return new Builder(context);
        }

        public Builder setDiscoveryListener(NsdManager.DiscoveryListener listener) {
            this.nsdHelper.discoveryListener = listener;
            return this;
        }

        public Builder setRegistrationListener(@NonNull NsdManager.RegistrationListener listener) {
            this.nsdHelper.registrationListener = listener;
            return this;
        }

        public Builder setResolveListener(@NonNull NsdManager.ResolveListener listener) {
            this.nsdHelper.resolveListener = listener;
            return this;
        }

        public NsdHelper build() {
            return this.nsdHelper;
        }
    }
}

