/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidbootstrap.communications.nsd;

import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.util.Log;

public abstract class DiscoveryListener
implements NsdManager.DiscoveryListener {
    private static final String TAG = DiscoveryListener.class.getSimpleName();

    public void onDiscoveryStarted(String regType) {
        Log.d((String)TAG, (String)"Service discovery started");
    }

    public void onServiceFound(NsdServiceInfo service) {
        Log.d((String)TAG, (String)("Service discovery success " + service));
    }

    public void onServiceLost(NsdServiceInfo service) {
        Log.e((String)TAG, (String)("service lost " + service));
    }

    public void onDiscoveryStopped(String serviceType) {
        Log.d((String)TAG, (String)("Discovery stopped: " + serviceType));
    }

    public void onStartDiscoveryFailed(String serviceType, int errorCode) {
        Log.d((String)TAG, (String)("Discovery failed: Error code: " + errorCode));
    }

    public void onStopDiscoveryFailed(String serviceType, int errorCode) {
        Log.d((String)TAG, (String)("Discovery failed: Error code: " + errorCode));
    }
}

