/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidbootstrap.communications.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.tunjid.androidbootstrap.communications.bluetooth.ScanRecordCompat;
import java.util.Arrays;

public final class ScanResultCompat
implements Parcelable {
    private BluetoothDevice mDevice;
    @Nullable
    private ScanRecordCompat mScanRecordCompat;
    private int mRssi;
    private long mTimestampNanos;
    public static final Parcelable.Creator<ScanResultCompat> CREATOR = new Parcelable.Creator<ScanResultCompat>(){

        public ScanResultCompat createFromParcel(Parcel source) {
            return new ScanResultCompat(source);
        }

        public ScanResultCompat[] newArray(int size) {
            return new ScanResultCompat[size];
        }
    };

    public ScanResultCompat(BluetoothDevice device, ScanRecordCompat scanRecordCompat, int rssi, long timestampNanos) {
        this.mDevice = device;
        this.mScanRecordCompat = scanRecordCompat;
        this.mRssi = rssi;
        this.mTimestampNanos = timestampNanos;
    }

    private ScanResultCompat(Parcel in) {
        this.readFromParcel(in);
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.mDevice != null) {
            dest.writeInt(1);
            this.mDevice.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        if (this.mScanRecordCompat != null) {
            dest.writeInt(1);
            dest.writeByteArray(this.mScanRecordCompat.getBytes());
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mRssi);
        dest.writeLong(this.mTimestampNanos);
    }

    private void readFromParcel(Parcel in) {
        if (in.readInt() == 1) {
            this.mDevice = (BluetoothDevice)BluetoothDevice.CREATOR.createFromParcel(in);
        }
        if (in.readInt() == 1) {
            this.mScanRecordCompat = ScanRecordCompat.parseFromBytes(in.createByteArray());
        }
        this.mRssi = in.readInt();
        this.mTimestampNanos = in.readLong();
    }

    public int describeContents() {
        return 0;
    }

    public BluetoothDevice getDevice() {
        return this.mDevice;
    }

    @Nullable
    public ScanRecordCompat getScanRecord() {
        return this.mScanRecordCompat;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public long getTimestampNanos() {
        return this.mTimestampNanos;
    }

    public int hashCode() {
        Object[] objects = new Object[]{this.mDevice, this.mRssi, this.mScanRecordCompat, this.mTimestampNanos};
        return Arrays.hashCode(objects);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScanResultCompat other = (ScanResultCompat)obj;
        return ScanResultCompat.equals(this.mDevice, other.mDevice) && this.mRssi == other.mRssi && ScanResultCompat.equals(this.mScanRecordCompat, other.mScanRecordCompat) && this.mTimestampNanos == other.mTimestampNanos;
    }

    public String toString() {
        return "ScanEvent{mDevice=" + this.mDevice + ", mScanRecord=" + String.valueOf(this.mScanRecordCompat) + ", mRssi=" + this.mRssi + ", mTimestampNanos=" + this.mTimestampNanos + '}';
    }

    private static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

