/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidbootstrap.communications.bluetooth;

import android.os.ParcelUuid;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.tunjid.androidbootstrap.communications.bluetooth.BluetoothUuid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ScanRecordCompat {
    private static final String TAG = "ScanRecord";
    private static final int DATA_TYPE_FLAGS = 1;
    private static final int DATA_TYPE_SERVICE_UUIDS_16_BIT_PARTIAL = 2;
    private static final int DATA_TYPE_SERVICE_UUIDS_16_BIT_COMPLETE = 3;
    private static final int DATA_TYPE_SERVICE_UUIDS_32_BIT_PARTIAL = 4;
    private static final int DATA_TYPE_SERVICE_UUIDS_32_BIT_COMPLETE = 5;
    private static final int DATA_TYPE_SERVICE_UUIDS_128_BIT_PARTIAL = 6;
    private static final int DATA_TYPE_SERVICE_UUIDS_128_BIT_COMPLETE = 7;
    private static final int DATA_TYPE_LOCAL_NAME_SHORT = 8;
    private static final int DATA_TYPE_LOCAL_NAME_COMPLETE = 9;
    private static final int DATA_TYPE_TX_POWER_LEVEL = 10;
    private static final int DATA_TYPE_SERVICE_DATA = 22;
    private static final int DATA_TYPE_MANUFACTURER_SPECIFIC_DATA = 255;
    private final int mAdvertiseFlags;
    @Nullable
    private final List<ParcelUuid> mServiceUuids;
    private final SparseArray<byte[]> mManufacturerSpecificData;
    private final Map<ParcelUuid, byte[]> mServiceData;
    private final int mTxPowerLevel;
    private final String mDeviceName;
    private final byte[] mBytes;

    public int getAdvertiseFlags() {
        return this.mAdvertiseFlags;
    }

    public List<ParcelUuid> getServiceUuids() {
        return this.mServiceUuids;
    }

    public SparseArray<byte[]> getManufacturerSpecificData() {
        return this.mManufacturerSpecificData;
    }

    @Nullable
    public byte[] getManufacturerSpecificData(int manufacturerId) {
        return (byte[])this.mManufacturerSpecificData.get(manufacturerId);
    }

    public Map<ParcelUuid, byte[]> getServiceData() {
        return this.mServiceData;
    }

    @Nullable
    public byte[] getServiceData(ParcelUuid serviceDataUuid) {
        if (serviceDataUuid == null) {
            return null;
        }
        return this.mServiceData.get(serviceDataUuid);
    }

    public int getTxPowerLevel() {
        return this.mTxPowerLevel;
    }

    @Nullable
    public String getDeviceName() {
        return this.mDeviceName;
    }

    public byte[] getBytes() {
        return this.mBytes;
    }

    private ScanRecordCompat(@Nullable List<ParcelUuid> serviceUuids, SparseArray<byte[]> manufacturerData, Map<ParcelUuid, byte[]> serviceData, int advertiseFlags, int txPowerLevel, String localName, byte[] bytes) {
        this.mServiceUuids = serviceUuids;
        this.mManufacturerSpecificData = manufacturerData;
        this.mServiceData = serviceData;
        this.mDeviceName = localName;
        this.mAdvertiseFlags = advertiseFlags;
        this.mTxPowerLevel = txPowerLevel;
        this.mBytes = bytes;
    }

    public static ScanRecordCompat parseFromBytes(byte[] scanRecord) {
        if (scanRecord == null) {
            return null;
        }
        int advertiseFlag = -1;
        ArrayList<ParcelUuid> serviceUuids = new ArrayList<ParcelUuid>();
        String localName = null;
        int txPowerLevel = Integer.MIN_VALUE;
        SparseArray manufacturerData = new SparseArray();
        ArrayMap serviceData = new ArrayMap();
        try {
            int length;
            int dataLength;
            block12: for (int currentPos = 0; currentPos < scanRecord.length && (length = scanRecord[currentPos++] & 0xFF) != 0; currentPos += dataLength) {
                dataLength = length - 1;
                int fieldType = scanRecord[currentPos++] & 0xFF;
                switch (fieldType) {
                    case 1: {
                        advertiseFlag = scanRecord[currentPos] & 0xFF;
                        continue block12;
                    }
                    case 2: 
                    case 3: {
                        ScanRecordCompat.parseServiceUuid(scanRecord, currentPos, dataLength, 2, serviceUuids);
                        continue block12;
                    }
                    case 4: 
                    case 5: {
                        ScanRecordCompat.parseServiceUuid(scanRecord, currentPos, dataLength, 4, serviceUuids);
                        continue block12;
                    }
                    case 6: 
                    case 7: {
                        ScanRecordCompat.parseServiceUuid(scanRecord, currentPos, dataLength, 16, serviceUuids);
                        continue block12;
                    }
                    case 8: 
                    case 9: {
                        localName = new String(ScanRecordCompat.extractBytes(scanRecord, currentPos, dataLength));
                        continue block12;
                    }
                    case 10: {
                        txPowerLevel = scanRecord[currentPos];
                        continue block12;
                    }
                    case 22: {
                        int serviceUuidLength = 2;
                        byte[] serviceDataUuidBytes = ScanRecordCompat.extractBytes(scanRecord, currentPos, serviceUuidLength);
                        ParcelUuid serviceDataUuid = BluetoothUuid.parseUuidFrom(serviceDataUuidBytes);
                        byte[] serviceDataArray = ScanRecordCompat.extractBytes(scanRecord, currentPos + serviceUuidLength, dataLength - serviceUuidLength);
                        serviceData.put(serviceDataUuid, serviceDataArray);
                        continue block12;
                    }
                    case 255: {
                        int manufacturerId = ((scanRecord[currentPos + 1] & 0xFF) << 8) + (scanRecord[currentPos] & 0xFF);
                        byte[] manufacturerDataBytes = ScanRecordCompat.extractBytes(scanRecord, currentPos + 2, dataLength - 2);
                        manufacturerData.put(manufacturerId, (Object)manufacturerDataBytes);
                        continue block12;
                    }
                }
            }
            if (serviceUuids.isEmpty()) {
                serviceUuids = null;
            }
            return new ScanRecordCompat(serviceUuids, (SparseArray<byte[]>)manufacturerData, (Map<ParcelUuid, byte[]>)serviceData, advertiseFlag, txPowerLevel, localName, scanRecord);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("unable to parse scan record: " + Arrays.toString(scanRecord)));
            return new ScanRecordCompat(null, null, null, -1, Integer.MIN_VALUE, null, scanRecord);
        }
    }

    public String toString() {
        return "ScanRecord [mAdvertiseFlags=" + this.mAdvertiseFlags + ", mServiceUuids=" + this.mServiceUuids + ", mManufacturerSpecificData=" + ScanRecordCompat.toString(this.mManufacturerSpecificData) + ", mServiceData=" + ScanRecordCompat.toString(this.mServiceData) + ", mTxPowerLevel=" + this.mTxPowerLevel + ", mDeviceName=" + this.mDeviceName + "]";
    }

    private static int parseServiceUuid(byte[] scanRecord, int currentPos, int dataLength, int uuidLength, List<ParcelUuid> serviceUuids) {
        while (dataLength > 0) {
            byte[] uuidBytes = ScanRecordCompat.extractBytes(scanRecord, currentPos, uuidLength);
            serviceUuids.add(BluetoothUuid.parseUuidFrom(uuidBytes));
            dataLength -= uuidLength;
            currentPos += uuidLength;
        }
        return currentPos;
    }

    private static byte[] extractBytes(byte[] scanRecord, int start, int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(scanRecord, start, bytes, 0, length);
        return bytes;
    }

    private static <T> String toString(Map<T, byte[]> map) {
        if (map == null) {
            return "null";
        }
        if (map.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        Iterator<Map.Entry<T, byte[]>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<T, byte[]> entry = it.next();
            T key = entry.getKey();
            buffer.append(key).append("=").append(Arrays.toString(map.get(key)));
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append('}');
        return buffer.toString();
    }

    private static String toString(SparseArray<byte[]> array) {
        if (array == null) {
            return "null";
        }
        if (array.size() == 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        for (int i = 0; i < array.size(); ++i) {
            buffer.append(array.keyAt(i)).append("=").append(Arrays.toString((byte[])array.valueAt(i)));
        }
        buffer.append('}');
        return buffer.toString();
    }
}

