/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidbootstrap.communications.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.os.Build;
import android.support.annotation.RequiresApi;
import com.tunjid.androidbootstrap.communications.bluetooth.ScanFilterCompat;
import com.tunjid.androidbootstrap.communications.bluetooth.ScanRecordCompat;
import com.tunjid.androidbootstrap.communications.bluetooth.ScanResultCompat;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=21)
public class BLEScanner {
    private final boolean hasLollipop;
    private final BluetoothAdapter bluetoothAdapter;
    private final List<ScanFilterCompat> compatFilters;
    private BleScanCallback callback;
    private ScanSettings scanSettings;
    private BluetoothAdapter.LeScanCallback oldCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            ScanResultCompat scanResultCompat = new ScanResultCompat(device, ScanRecordCompat.parseFromBytes(scanRecord), rssi, 0L);
            if (BLEScanner.this.matchesFilters(scanResultCompat)) {
                BLEScanner.this.callback.onDeviceFound(scanResultCompat);
            }
        }
    };
    private ScanCallback newCallback = new ScanCallback(){

        public void onScanResult(int callbackType, ScanResult result) {
            byte[] scanRecord = result.getScanRecord() == null ? null : result.getScanRecord().getBytes();
            ScanResultCompat scanResultCompat = new ScanResultCompat(result.getDevice(), ScanRecordCompat.parseFromBytes(scanRecord), result.getRssi(), result.getTimestampNanos());
            if (BLEScanner.this.matchesFilters(scanResultCompat)) {
                BLEScanner.this.callback.onDeviceFound(scanResultCompat);
            }
        }

        public void onScanFailed(int errorCode) {
        }
    };

    public static Builder getBuilder(BluetoothAdapter adapter) {
        return new Builder(adapter);
    }

    private BLEScanner(BluetoothAdapter bluetoothAdapter) {
        this.hasLollipop = Build.VERSION.SDK_INT >= 21;
        this.bluetoothAdapter = bluetoothAdapter;
        this.compatFilters = new ArrayList<ScanFilterCompat>();
    }

    public boolean isEnabled() {
        return this.bluetoothAdapter.isEnabled();
    }

    public void startScan() {
        if (this.hasLollipop) {
            this.bluetoothAdapter.getBluetoothLeScanner().startScan(this.newCallback);
        } else {
            this.bluetoothAdapter.startLeScan(this.oldCallback);
        }
    }

    public void stopScan() {
        if (this.hasLollipop) {
            this.bluetoothAdapter.getBluetoothLeScanner().stopScan(this.newCallback);
        } else {
            this.bluetoothAdapter.stopLeScan(this.oldCallback);
        }
    }

    private boolean matchesFilters(ScanResultCompat result) {
        if (this.compatFilters.isEmpty()) {
            return true;
        }
        for (ScanFilterCompat filter : this.compatFilters) {
            if (!filter.matches(result)) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private final BLEScanner scanner;

        private Builder(BluetoothAdapter adapter) {
            this.scanner = new BLEScanner(adapter);
        }

        public Builder withCallBack(BleScanCallback callBack) {
            if (callBack == null) {
                throw new IllegalArgumentException("Scan callback cannot be null");
            }
            this.scanner.callback = callBack;
            return this;
        }

        @RequiresApi(value=21)
        public Builder withSettings(ScanSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException("Scan settings cannot be null");
            }
            if (this.scanner.hasLollipop) {
                this.scanner.scanSettings = settings;
            }
            return this;
        }

        public Builder addFilter(ScanFilterCompat filterCompat) {
            if (filterCompat == null) {
                throw new IllegalArgumentException("Scan filter cannot be null");
            }
            this.scanner.compatFilters.add(filterCompat);
            return this;
        }

        public BLEScanner build() {
            if (this.scanner.callback == null) {
                throw new IllegalArgumentException("Scan callback cannot be null");
            }
            if (this.scanner.hasLollipop && this.scanner.scanSettings == null) {
                this.scanner.scanSettings = new ScanSettings.Builder().build();
            }
            return this.scanner;
        }
    }

    public static interface BleScanCallback {
        public void onDeviceFound(ScanResultCompat var1);
    }
}

