/*
 * Decompiled with CFR 0.152.
 */
package com.tumblr.backboard.imitator;

import android.support.annotation.NonNull;
import android.view.MotionEvent;
import android.view.View;
import com.facebook.rebound.Spring;
import com.tumblr.backboard.MotionProperty;
import com.tumblr.backboard.imitator.EventImitator;

public class MotionImitator
extends EventImitator {
    private static final String TAG = MotionImitator.class.getSimpleName();
    @NonNull
    protected MotionProperty mProperty;
    protected float mDownPosition;
    protected float mOffset;

    public MotionImitator(@NonNull MotionProperty property) {
        this(null, property, 0.0, 1, 1);
    }

    public MotionImitator(@NonNull MotionProperty property, int trackStrategy, int followStrategy) {
        this(null, property, 0.0, trackStrategy, followStrategy);
    }

    public MotionImitator(@NonNull Spring spring, @NonNull MotionProperty property) {
        this(spring, property, spring.getEndValue(), 1, 1);
    }

    public MotionImitator(@NonNull Spring spring, @NonNull MotionProperty property, double restValue) {
        this(spring, property, restValue, 1, 1);
    }

    public MotionImitator(@NonNull Spring spring, @NonNull MotionProperty property, double restValue, int trackStrategy, int followStrategy) {
        super(spring, restValue, trackStrategy, followStrategy);
        this.mProperty = property;
    }

    public MotionImitator(@NonNull MotionProperty property, double restValue, int trackStrategy, int followStrategy) {
        super(restValue, trackStrategy, followStrategy);
        this.mProperty = property;
    }

    public void setRestValue(double restValue) {
        this.mRestValue = restValue;
    }

    @NonNull
    public MotionImitator rest() {
        if (this.mSpring != null) {
            this.mSpring.setEndValue(this.mRestValue);
        }
        return this;
    }

    @Override
    public void constrain(MotionEvent event) {
        super.constrain(event);
        this.mDownPosition = this.mProperty.getValue(event) + this.mOffset;
    }

    @Override
    public void imitate(View view, @NonNull MotionEvent event) {
        float viewValue = this.mProperty.getValue(view);
        float eventValue = this.mProperty.getValue(event);
        this.mOffset = this.mProperty.getOffset(view);
        if (event.getHistorySize() > 0) {
            float historicalValue = this.mProperty.getOldestValue(event);
            this.imitate(viewValue + this.mOffset, eventValue, eventValue - historicalValue, event);
        } else {
            this.imitate(viewValue + this.mOffset, eventValue, 0.0f, event);
        }
    }

    @Override
    public void mime(float offset, float value, float delta, float dt, MotionEvent event) {
        if (this.mTrackStrategy == 2) {
            super.mime(offset - this.mDownPosition, value, delta, dt, event);
        } else {
            super.mime(offset, value, delta, dt, event);
        }
    }

    @Override
    protected double mapToSpring(float motionValue) {
        return motionValue;
    }

    @NonNull
    public MotionProperty getProperty() {
        return this.mProperty;
    }
}

