/*
 * Decompiled with CFR 0.152.
 */
package com.tumblr.backboard.imitator;

import android.support.annotation.NonNull;
import android.view.MotionEvent;
import com.facebook.rebound.Spring;
import com.facebook.rebound.SpringConfig;
import com.facebook.rebound.SpringListener;
import com.tumblr.backboard.MotionProperty;
import com.tumblr.backboard.imitator.ConstrainedMotionImitator;

public class InertialImitator
extends ConstrainedMotionImitator
implements SpringListener {
    public static final float DEFAULT_FRICTION = 1.0f;
    public static final SpringConfig SPRING_CONFIG_FRICTION = new SpringConfig(0.0, 1.0);
    public static final int VELOCITY_RATIO = 24;
    protected SpringConfig mOriginalConfig;

    public InertialImitator(@NonNull MotionProperty property, double minValue, double maxValue) {
        super(property, minValue, maxValue);
    }

    public InertialImitator(@NonNull MotionProperty property, int trackStrategy, int followStrategy, double minValue, double maxValue) {
        super(property, trackStrategy, followStrategy, minValue, maxValue);
    }

    @Override
    public void setSpring(@NonNull Spring spring) {
        super.setSpring(spring);
        spring.addListener((SpringListener)this);
        this.mOriginalConfig = spring.getSpringConfig();
    }

    @Override
    public void constrain(MotionEvent event) {
        super.constrain(event);
        this.mSpring.setSpringConfig(this.mOriginalConfig);
    }

    @Override
    public void release(MotionEvent event) {
        double restPosition = this.calculateRestPosition();
        if (this.mSpring.getCurrentValue() > this.mMaxValue && restPosition > this.mMaxValue) {
            this.mSpring.setEndValue(this.mMaxValue);
        } else if (this.mSpring.getCurrentValue() < this.mMinValue && restPosition < this.mMinValue) {
            this.mSpring.setEndValue(this.mMinValue);
        } else {
            this.mSpring.setSpringConfig(SPRING_CONFIG_FRICTION);
            this.mSpring.setEndValue(Double.MAX_VALUE);
        }
    }

    private double calculateRestPosition() {
        return this.mSpring.getCurrentValue() + 24.0 * this.mSpring.getVelocity() / this.mSpring.getSpringConfig().friction;
    }

    @Override
    public void setMinValue(double minValue) {
        this.mMinValue = minValue;
    }

    @Override
    public void setMaxValue(double maxValue) {
        this.mMaxValue = maxValue;
    }

    public void onSpringUpdate(Spring spring) {
        if (this.mSpring != null) {
            double restPosition = this.calculateRestPosition();
            if (this.mSpring.getSpringConfig().equals(SPRING_CONFIG_FRICTION)) {
                if (this.mSpring.getCurrentValue() > this.mMaxValue && restPosition > this.mMaxValue) {
                    this.mSpring.setSpringConfig(this.mOriginalConfig);
                    this.mSpring.setEndValue(this.mMaxValue);
                } else if (this.mSpring.getCurrentValue() < this.mMinValue && restPosition < this.mMinValue) {
                    this.mSpring.setSpringConfig(this.mOriginalConfig);
                    this.mSpring.setEndValue(this.mMinValue);
                }
            }
        }
    }

    public void onSpringAtRest(Spring spring) {
    }

    public void onSpringActivate(Spring spring) {
    }

    public void onSpringEndStateChange(Spring spring) {
    }
}

