/*
 * Decompiled with CFR 0.152.
 */
package com.tumblr.backboard.imitator;

import android.support.annotation.NonNull;
import com.facebook.rebound.Spring;

public abstract class Imitator {
    public static final int TRACK_ABSOLUTE = 1;
    protected int mTrackStrategy = 1;
    public static final int TRACK_DELTA = 2;
    public static final int FOLLOW_EXACT = 1;
    protected int mFollowStrategy = 1;
    public static final int FOLLOW_SPRING = 2;
    @NonNull
    protected Spring mSpring;
    protected double mRestValue;

    protected Imitator(double restValue, int trackStrategy, int followStrategy) {
        this(null, restValue, trackStrategy, followStrategy);
    }

    protected Imitator(@NonNull Spring spring) {
        this(spring, 1, 1);
    }

    protected Imitator(@NonNull Spring spring, int trackStrategy, int followStrategy) {
        this(spring, spring.getEndValue(), trackStrategy, followStrategy);
    }

    protected Imitator(@NonNull Spring spring, double restValue, int trackStrategy, int followStrategy) {
        this.mSpring = spring;
        this.mRestValue = restValue;
        this.mTrackStrategy = trackStrategy;
        this.mFollowStrategy = followStrategy;
    }

    protected abstract double mapToSpring(float var1);

    public int getTrackStrategy() {
        return this.mTrackStrategy;
    }

    @NonNull
    public Imitator setTrackStrategy(int trackStrategy) {
        this.mTrackStrategy = trackStrategy;
        return this;
    }

    public int getFollowStrategy() {
        return this.mFollowStrategy;
    }

    @NonNull
    public Imitator setFollowStrategy(int followStrategy) {
        this.mFollowStrategy = followStrategy;
        return this;
    }

    @NonNull
    public Spring getSpring() {
        return this.mSpring;
    }

    public void setSpring(@NonNull Spring spring) {
        this.mSpring = spring;
        if (this.mSpring != null) {
            this.mSpring.setCurrentValue(this.mRestValue, true);
        }
    }
}

