/*
 * Decompiled with CFR 0.152.
 */
package com.tumblr.backboard.imitator;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import com.facebook.rebound.Spring;
import com.tumblr.backboard.imitator.Imitator;

public abstract class EventImitator
extends Imitator {
    public EventImitator(@NonNull Spring spring, double restValue, int trackStrategy, int followStrategy) {
        super(spring, restValue, trackStrategy, followStrategy);
    }

    protected EventImitator(double restValue, int trackStrategy, int followStrategy) {
        super(restValue, trackStrategy, followStrategy);
    }

    public void constrain(MotionEvent event) {
        if (this.mSpring != null && this.mFollowStrategy == 1) {
            this.mSpring.setVelocity(0.0);
        }
    }

    public void mime(float offset, float value, float delta, float dt, MotionEvent event) {
        if (this.mSpring != null) {
            this.mSpring.setEndValue(this.mapToSpring(offset + value));
            if (this.mFollowStrategy == 1) {
                this.mSpring.setCurrentValue(this.mSpring.getEndValue());
                if (dt > 0.0f) {
                    this.mSpring.setVelocity((double)(delta / dt));
                }
            }
        }
    }

    public void release(MotionEvent event) {
        if (this.mSpring != null) {
            this.mSpring.setEndValue(this.mRestValue);
        }
    }

    protected void imitate(float offset, float value, float delta, @Nullable MotionEvent event) {
        if (event != null) {
            switch (event.getAction()) {
                case 0: {
                    this.constrain(event);
                }
                case 2: {
                    if (event.getHistorySize() > 0) {
                        this.mime(offset, value, delta, event.getEventTime() - event.getHistoricalEventTime(0), event);
                        break;
                    }
                    this.mime(offset, value, delta, 0.0f, event);
                    break;
                }
                default: {
                    this.release(event);
                }
            }
        }
    }

    public abstract void imitate(View var1, @NonNull MotionEvent var2);
}

