/*
 * Decompiled with CFR 0.152.
 */
package com.tumblr.backboard;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;

public enum MotionProperty {
    X((Property<View, Float>)View.TRANSLATION_X),
    Y((Property<View, Float>)View.TRANSLATION_Y);

    @NonNull
    private final Property<View, Float> mViewProperty;

    private MotionProperty(Property<View, Float> viewProperty) {
        this.mViewProperty = viewProperty;
    }

    @NonNull
    public Property<View, Float> getViewProperty() {
        return this.mViewProperty;
    }

    public float getValue(@Nullable View view) {
        if (view != null) {
            return ((Float)this.mViewProperty.get((Object)view)).floatValue();
        }
        return 0.0f;
    }

    public float getValue(@Nullable MotionEvent event) {
        if (event != null) {
            switch (this) {
                case X: {
                    return event.getX(0);
                }
                case Y: {
                    return event.getY(0);
                }
            }
            return event.getX(0);
        }
        return 0.0f;
    }

    public float getHistoricalValue(@Nullable MotionEvent event, int index) {
        if (event != null) {
            switch (this) {
                case X: {
                    return event.getHistoricalX(index);
                }
                case Y: {
                    return event.getHistoricalY(index);
                }
            }
            return 0.0f;
        }
        return 0.0f;
    }

    public float getOldestValue(MotionEvent event) {
        return this.getHistoricalValue(event, 0);
    }

    public float getOffset(@Nullable View view) {
        if (view != null) {
            switch (this) {
                case X: {
                    return -view.getWidth() / 2;
                }
                case Y: {
                    return -view.getHeight() / 2;
                }
            }
            return -view.getWidth() / 2;
        }
        return 0.0f;
    }
}

