/*
 * Decompiled with CFR 0.152.
 */
package com.tumblr.backboard;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import com.facebook.rebound.Spring;
import com.facebook.rebound.SpringListener;
import com.facebook.rebound.SpringSystem;
import com.tumblr.backboard.MotionProperty;
import com.tumblr.backboard.imitator.EventImitator;
import com.tumblr.backboard.imitator.MotionImitator;
import com.tumblr.backboard.performer.Performer;
import java.util.ArrayList;
import java.util.List;

public final class Actor {
    public static final int MAX_CLICK_DISTANCE = 10;
    @NonNull
    private final View mView;
    @NonNull
    private final List<Motion> mMotions;
    @NonNull
    private final MotionListener mMotionListener;
    @Nullable
    private final View.OnTouchListener mOnTouchListener;
    private boolean mMotionListenerEnabled;
    private boolean mRequestDisallowTouchEvent;

    private Actor(@NonNull View view, @NonNull List<Motion> motions, @Nullable View.OnTouchListener onTouchListener, boolean motionListenerEnabled, boolean attachTouchListener, boolean requestDisallowTouchEvent) {
        this.mView = view;
        this.mMotions = motions;
        this.mOnTouchListener = onTouchListener;
        this.mMotionListener = new MotionListener();
        this.mMotionListenerEnabled = motionListenerEnabled;
        this.mRequestDisallowTouchEvent = requestDisallowTouchEvent;
        if (attachTouchListener) {
            view.setOnTouchListener((View.OnTouchListener)this.mMotionListener);
        }
    }

    @Nullable
    public View.OnTouchListener getOnTouchListener() {
        return this.mOnTouchListener;
    }

    @NonNull
    public View.OnTouchListener getMotionListener() {
        return this.mMotionListener;
    }

    @NonNull
    public View getView() {
        return this.mView;
    }

    @NonNull
    public List<Motion> getMotions() {
        return this.mMotions;
    }

    public boolean isTouchEnabled() {
        return this.mMotionListenerEnabled;
    }

    public void setTouchEnabled(boolean enabled) {
        this.mMotionListenerEnabled = enabled;
    }

    public void removeAllListeners() {
        for (Motion motion : this.mMotions) {
            for (Performer performer : motion.performers) {
                motion.spring.removeListener((SpringListener)performer);
            }
            if (motion.springListeners == null) continue;
            for (Performer performer : motion.springListeners) {
                motion.spring.removeListener((SpringListener)performer);
            }
        }
    }

    public void addAllListeners() {
        for (Motion motion : this.mMotions) {
            for (Performer performer : motion.performers) {
                motion.spring.addListener((SpringListener)performer);
            }
            if (motion.springListeners == null) continue;
            for (Performer performer : motion.springListeners) {
                motion.spring.addListener((SpringListener)performer);
            }
        }
    }

    private class MotionListener
    implements View.OnTouchListener {
        private MotionListener() {
        }

        @SuppressLint(value={"ClickableViewAccessibility"})
        public boolean onTouch(@NonNull View v, @NonNull MotionEvent event) {
            if (!Actor.this.mMotionListenerEnabled || Actor.this.mMotions.isEmpty()) {
                boolean retVal = Actor.this.mOnTouchListener != null ? Actor.this.mOnTouchListener.onTouch(v, event) : false;
                return retVal;
            }
            for (Motion motion : Actor.this.mMotions) {
                for (EventImitator imitator : motion.imitators) {
                    imitator.imitate(v, event);
                }
            }
            boolean retVal = Actor.this.mOnTouchListener != null ? Actor.this.mOnTouchListener.onTouch(v, event) : true;
            if (Actor.this.mRequestDisallowTouchEvent) {
                v.getParent().requestDisallowInterceptTouchEvent(true);
            }
            if (v.isClickable()) {
                if (event.getEventTime() - event.getDownTime() > (long)ViewConfiguration.getLongPressTimeout()) {
                    v.setPressed(false);
                    return true;
                }
                if (event.getHistorySize() > 0) {
                    float deltaX = event.getHistoricalX(event.getHistorySize() - 1) - event.getX();
                    float deltaY = event.getHistoricalY(event.getHistorySize() - 1) - event.getY();
                    boolean removeClickState = Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0) > Math.pow(10.0, 2.0);
                    v.setPressed(!removeClickState);
                    return removeClickState;
                }
                return false;
            }
            return retVal;
        }
    }

    public static class Builder {
        @NonNull
        private final View mView;
        @NonNull
        private final List<Motion> mMotions = new ArrayList<Motion>();
        @Nullable
        private View.OnTouchListener mOnTouchListener;
        @NonNull
        private final SpringSystem mSpringSystem;
        private boolean mMotionListenerEnabled = true;
        private boolean mAttachMotionListener = true;
        private boolean mRequestDisallowTouchEvent;
        private boolean mAttachSpringListeners = true;

        public Builder(@NonNull SpringSystem springSystem, @NonNull View view) {
            this.mView = view;
            this.mSpringSystem = springSystem;
        }

        @NonNull
        public Builder onTouchListener(View.OnTouchListener onTouchListener) {
            this.mOnTouchListener = onTouchListener;
            return this;
        }

        @NonNull
        public Builder addTranslateMotion(MotionProperty ... properties) {
            return this.addMotion(this.mSpringSystem.createSpring(), properties);
        }

        @NonNull
        public Builder addTranslateMotion(MotionProperty property, SpringListener listener) {
            return this.addMotion(this.mSpringSystem.createSpring(), 1, 1, new MotionProperty[]{property}, new SpringListener[]{listener});
        }

        @NonNull
        public Builder addTranslateMotion(int trackStrategy, int followStrategy, MotionProperty ... properties) {
            return this.addMotion(this.mSpringSystem.createSpring(), trackStrategy, followStrategy, properties);
        }

        @NonNull
        public Builder addTranslateMotion(int trackStrategy, int followStrategy, int restValue, MotionProperty ... properties) {
            return this.addMotion(this.mSpringSystem.createSpring(), trackStrategy, followStrategy, restValue, properties);
        }

        @NonNull
        public Builder addMotion(@NonNull Spring spring, MotionProperty ... properties) {
            return this.addMotion(spring, 1, 1, properties);
        }

        @NonNull
        public Builder addMotion(@NonNull Spring spring, int trackStrategy, int followStrategy, MotionProperty ... properties) {
            this.mMotions.add(this.createMotionFromProperties(spring, properties, null, trackStrategy, followStrategy, 0));
            return this;
        }

        @NonNull
        public Builder addMotion(@NonNull Spring spring, int trackStrategy, int followStrategy, int restValue, MotionProperty ... properties) {
            this.mMotions.add(this.createMotionFromProperties(spring, properties, null, trackStrategy, followStrategy, restValue));
            return this;
        }

        @NonNull
        public Builder addMotion(@NonNull Spring spring, int trackStrategy, int followStrategy, int restValue, MotionProperty property, @Nullable SpringListener springListener) {
            this.mMotions.add(this.createMotionFromProperties(spring, new MotionProperty[]{property}, new SpringListener[]{springListener}, trackStrategy, followStrategy, restValue));
            return this;
        }

        @NonNull
        public Builder addMotion(@NonNull Spring spring, int trackStrategy, int followStrategy, @NonNull MotionProperty[] properties, SpringListener[] springListeners) {
            this.mMotions.add(this.createMotionFromProperties(spring, properties, springListeners, trackStrategy, followStrategy, 0));
            return this;
        }

        @NonNull
        public Builder addMotion(@NonNull EventImitator eventImitator, Property<View, Float> ... viewProperties) {
            Performer[] performers = new Performer[viewProperties.length];
            for (int i = 0; i < viewProperties.length; ++i) {
                performers[i] = new Performer(viewProperties[i]);
            }
            return this.addMotion(this.mSpringSystem.createSpring(), eventImitator, performers);
        }

        @NonNull
        public Builder addMotion(@NonNull EventImitator eventImitator, Performer ... performers) {
            return this.addMotion(this.mSpringSystem.createSpring(), eventImitator, performers);
        }

        @NonNull
        public Builder addMotion(@NonNull Spring spring, @NonNull EventImitator eventImitator, Performer ... performers) {
            Motion motion = new Motion(spring, eventImitator, performers, null);
            motion.imitators[0].setSpring(motion.spring);
            for (Performer performer : motion.performers) {
                performer.setTarget(this.mView);
            }
            this.mMotions.add(motion);
            return this;
        }

        @NonNull
        public Builder addMotion(@NonNull Spring spring, @NonNull EventImitator eventImitator, @NonNull Performer[] performers, SpringListener[] springListeners) {
            Motion motion = new Motion(spring, eventImitator, performers, springListeners);
            motion.imitators[0].setSpring(motion.spring);
            for (Performer performer : motion.performers) {
                performer.setTarget(this.mView);
            }
            this.mMotions.add(motion);
            return this;
        }

        @NonNull
        public Builder addMotion(@NonNull MotionImitator motionImitator, @NonNull Property<View, Float> viewProperty, SpringListener springListener) {
            return this.addMotion(this.mSpringSystem.createSpring(), (EventImitator)motionImitator, new Performer[]{new Performer(viewProperty)}, new SpringListener[]{springListener});
        }

        @NonNull
        public Builder requestDisallowTouchEvent() {
            this.mRequestDisallowTouchEvent = true;
            return this;
        }

        @NonNull
        public Builder dontAttachMotionListener() {
            this.mAttachMotionListener = false;
            return this;
        }

        @NonNull
        public Builder dontAttachSpringListeners() {
            this.mAttachSpringListeners = false;
            return this;
        }

        @Nullable
        private Motion createMotionFromProperties(@NonNull Spring spring, @NonNull MotionProperty[] motionProperties, @Nullable SpringListener[] springListeners, int trackStrategy, int followStrategy, int restValue) {
            EventImitator[] motionImitators = new MotionImitator[motionProperties.length];
            Performer[] performers = new Performer[motionProperties.length];
            for (int i = 0; i < motionProperties.length; ++i) {
                MotionProperty property = motionProperties[i];
                motionImitators[i] = new MotionImitator(spring, property, restValue, trackStrategy, followStrategy);
                performers[i] = new Performer(this.mView, property.getViewProperty());
            }
            return new Motion(spring, motionImitators, performers, springListeners);
        }

        @NonNull
        public Actor build() {
            Actor actor = new Actor(this.mView, this.mMotions, this.mOnTouchListener, this.mMotionListenerEnabled, this.mAttachMotionListener, this.mRequestDisallowTouchEvent);
            if (this.mAttachSpringListeners) {
                actor.addAllListeners();
            }
            return actor;
        }
    }

    public static final class Motion {
        @NonNull
        private final Spring spring;
        @NonNull
        private final EventImitator[] imitators;
        @NonNull
        private final Performer[] performers;
        @Nullable
        private final SpringListener[] springListeners;

        private Motion(@NonNull Spring spring, @NonNull EventImitator imitator, @NonNull Performer[] performers, @Nullable SpringListener[] springListeners) {
            this(spring, new EventImitator[]{imitator}, performers, springListeners);
        }

        private Motion(@NonNull Spring spring, @NonNull Performer[] performers, @Nullable SpringListener[] springListeners) {
            this.imitators = new MotionImitator[0];
            this.performers = performers;
            this.spring = spring;
            this.springListeners = springListeners;
        }

        private Motion(@NonNull Spring spring, @NonNull EventImitator[] imitators, @NonNull Performer[] performers, @Nullable SpringListener[] springListeners) {
            this.imitators = imitators;
            this.performers = performers;
            this.spring = spring;
            this.springListeners = springListeners;
        }

        @NonNull
        public Spring getSpring() {
            return this.spring;
        }

        @NonNull
        public EventImitator[] getImitators() {
            return this.imitators;
        }
    }
}

