/*
 * Decompiled with CFR 0.152.
 */
package com.tubitv.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.tubitv.ui.R;

public class TubiLoadingView
extends AppCompatImageView {
    private static final int DEFAULT_ROTATION_DURATION_MS = 1000;
    private int mRotationDuration = 1000;
    private Animation mRotateAnim;
    private boolean mIsRunning;

    public TubiLoadingView(Context context) {
        super(context);
        this.init(null);
    }

    public TubiLoadingView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public TubiLoadingView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(@Nullable AttributeSet attrs) {
        this.setImageDrawable(this.getResources().getDrawable(R.drawable.ic_tubi_tv_loading_spinner));
        if (this.isInEditMode()) {
            return;
        }
        if (attrs != null) {
            TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.TubiLoadingView, 0, 0);
            try {
                this.mRotationDuration = a.getInt(R.styleable.TubiLoadingView_rotation_duration_ms, 1000);
            }
            finally {
                a.recycle();
            }
        }
        this.mRotateAnim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.tubi_tv_loading_spinner_rotate);
        this.start();
    }

    public void toggle() {
        if (this.mIsRunning) {
            this.stop();
        } else {
            this.start();
        }
    }

    public void stop() {
        if (!this.mIsRunning) {
            return;
        }
        this.clearAnimation();
        this.setVisibility(8);
        this.mIsRunning = false;
    }

    public void start() {
        if (this.mIsRunning) {
            return;
        }
        this.mRotateAnim.setDuration((long)this.mRotationDuration);
        this.setVisibility(0);
        this.startAnimation(this.mRotateAnim);
        this.mIsRunning = true;
    }
}

