/*
 * Decompiled with CFR 0.152.
 */
package com.tuacy.sectionpin;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.tuacy.sectionpin.R;
import com.tuacy.sectionpin.SectionPinAdapter;

public class SectionPinListView
extends ListView
implements AbsListView.OnScrollListener {
    private AbsListView.OnScrollListener mScrollListener = null;
    private View mViewSectionPin = null;
    private boolean mSectionPinEnable = true;
    private float mSectionPinOffset = 0.0f;
    private int mSectionPinAdapterPosition = -1;
    private int mWidthMode = 0x40000000;

    public SectionPinListView(Context context) {
        this(context, null);
    }

    public SectionPinListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SectionPinListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.SectionPinListView);
        this.mSectionPinEnable = array.getBoolean(R.styleable.SectionPinListView_section_pin, true);
        array.recycle();
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
    }

    public void setSectionPinEnable(boolean enable) {
        this.mSectionPinEnable = enable;
    }

    public void setAdapter(ListAdapter adapter) {
        super.setAdapter(adapter);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener listener) {
        this.mScrollListener = listener;
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.getAdapter() == null || !(this.getAdapter() instanceof SectionPinAdapter) || this.mViewSectionPin == null || !this.mSectionPinEnable) {
            return;
        }
        int saveCount = canvas.save();
        canvas.translate(0.0f, this.mSectionPinOffset);
        canvas.clipRect(0, 0, this.getWidth(), this.mViewSectionPin.getMeasuredHeight());
        this.mViewSectionPin.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
    }

    public void onScrollStateChanged(AbsListView absListView, int scrollState) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(absListView, scrollState);
        }
    }

    public void onScroll(AbsListView absListView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onScroll(absListView, firstVisibleItem, visibleItemCount, totalItemCount);
        }
        if (this.getAdapter() != null && !(this.getAdapter() instanceof SectionPinAdapter)) {
            return;
        }
        int headerViewCount = this.getHeaderViewsCount();
        if (this.getAdapter() == null || !this.mSectionPinEnable || firstVisibleItem < headerViewCount) {
            this.mViewSectionPin = null;
            this.mSectionPinOffset = 0.0f;
            this.mSectionPinAdapterPosition = -1;
            for (int i = 0; i < visibleItemCount; ++i) {
                View view = this.getChildAt(i);
                if (view == null) continue;
                view.setVisibility(0);
            }
            return;
        }
        if (this.getAdapter().getCount() <= 0) {
            return;
        }
        int adapterFirstVisibleItem = firstVisibleItem - headerViewCount;
        int pinViewAdapterPosition = this.getPinViewAdapterPosition(adapterFirstVisibleItem);
        if (pinViewAdapterPosition != -1 && this.mSectionPinAdapterPosition != pinViewAdapterPosition) {
            this.mViewSectionPin = this.getSectionPinView(pinViewAdapterPosition);
            this.ensurePinViewLayout(this.mViewSectionPin);
        }
        if (this.mViewSectionPin == null) {
            return;
        }
        this.mSectionPinOffset = 0.0f;
        for (int index = 0; index < visibleItemCount; ++index) {
            int adapterPosition = index + adapterFirstVisibleItem;
            SectionPinAdapter adapter = (SectionPinAdapter)this.getAdapter();
            if (!adapter.isSection(adapterPosition)) continue;
            View sectionView = this.getChildAt(index);
            int sectionTop = sectionView.getTop();
            int pinViewHeight = this.mViewSectionPin.getHeight();
            sectionView.setVisibility(0);
            if (sectionTop < pinViewHeight && sectionTop > 0) {
                this.mSectionPinOffset = sectionTop - pinViewHeight;
                continue;
            }
            if (sectionTop > 0) continue;
            sectionView.setVisibility(4);
        }
        this.invalidate();
    }

    private View getSectionPinView(int adapterPosition) {
        if (this.getAdapter() == null) {
            return null;
        }
        return this.getAdapter().getView(adapterPosition, null, (ViewGroup)this);
    }

    private int getPinViewAdapterPosition(int adapterFirstVisible) {
        if (this.getAdapter() == null || !(this.getAdapter() instanceof SectionPinAdapter)) {
            return -1;
        }
        SectionPinAdapter adapter = (SectionPinAdapter)this.getAdapter();
        for (int index = adapterFirstVisible; index >= 0; --index) {
            if (!adapter.isSection(index)) continue;
            return index;
        }
        return -1;
    }

    private void ensurePinViewLayout(View pinView) {
        if (pinView.isLayoutRequested()) {
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)this.mWidthMode);
            ViewGroup.LayoutParams layoutParams = pinView.getLayoutParams();
            int heightSpec = layoutParams != null && layoutParams.height > 0 ? View.MeasureSpec.makeMeasureSpec((int)layoutParams.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            pinView.measure(widthSpec, heightSpec);
            pinView.layout(0, 0, pinView.getMeasuredWidth(), pinView.getMeasuredHeight());
        }
    }
}

