/*
 * Decompiled with CFR 0.152.
 */
package com.tuacy.logger.bean;

public class LoggerInfo {
    private LogLevel mLogLevel;
    private String mTag;
    private String mMessage;
    private String mThreadName;
    private StackTraceElement[] mStackTrace;
    private int mStackCount;

    public void apply(Builder builder) {
        this.mLogLevel = builder.mLogLevel;
        this.mTag = builder.mTag;
        this.mMessage = builder.mMessage;
        this.mThreadName = builder.mThreadName;
        this.mStackTrace = builder.mStackTrace;
        this.mStackCount = builder.mStackCount;
    }

    public LogLevel getLogLevel() {
        return this.mLogLevel;
    }

    public String getTag() {
        return this.mTag;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public String getThreadName() {
        return this.mThreadName;
    }

    public StackTraceElement[] getStackTrace() {
        return this.mStackTrace;
    }

    public int getStackCount() {
        return this.mStackCount;
    }

    public static class Builder {
        private LogLevel mLogLevel;
        private String mTag;
        private String mMessage;
        private String mThreadName;
        private StackTraceElement[] mStackTrace;
        private int mStackCount;

        public Builder(LogLevel logLevel, String tag, String message) {
            this.mLogLevel = logLevel;
            this.mTag = tag;
            this.mMessage = message;
        }

        public Builder threadName(String threadName) {
            this.mThreadName = threadName;
            return this;
        }

        public Builder stackTrace(StackTraceElement[] traceElements, int stackCount) {
            this.mStackTrace = traceElements;
            this.mStackCount = stackCount;
            return this;
        }

        public LoggerInfo build() {
            LoggerInfo info = new LoggerInfo();
            info.apply(this);
            return info;
        }
    }

    public static enum LogLevel {
        VERBOSE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        ASSERT;

    }
}

