/*
 * Decompiled with CFR 0.152.
 */
package com.tuacy.logger;

import com.tuacy.logger.parse.IParser;
import com.tuacy.logger.parse.TabUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

public class LoggerTransform {
    private static final int MAX_CHILD_LEVEL = 3;
    private static final String STRING_OBJECT_NULL = "Object[object is null]";

    public static String transformToString(Object object, List<IParser> parsers) {
        return LoggerTransform.transformToString(object, 0, parsers, 0);
    }

    public static String transformToString(Object object, int tab, List<IParser> parsers) {
        return LoggerTransform.transformToString(object, tab, parsers, 0);
    }

    public static String transformToString(Object object, List<IParser> parsers, int childLevel) {
        return LoggerTransform.transformToString(object, 0, parsers, childLevel);
    }

    public static String transformToString(Object object, int tab, List<IParser> parsers, int childLevel) {
        if (object == null) {
            return STRING_OBJECT_NULL;
        }
        if (parsers != null && parsers.size() > 0) {
            for (IParser parser : parsers) {
                if (!parser.classType().isAssignableFrom(object.getClass())) continue;
                return parser.parse(object, tab, parsers);
            }
        }
        if (LoggerTransform.isArray(object)) {
            return LoggerTransform.parseArray(object, tab, parsers);
        }
        if (object.toString().startsWith(object.getClass().getName() + "@")) {
            StringBuilder builder = new StringBuilder();
            LoggerTransform.getClassFields(object.getClass(), tab, builder, object, false, childLevel, parsers);
            Class<?> superClass = object.getClass().getSuperclass();
            while (!superClass.equals(Object.class)) {
                LoggerTransform.getClassFields(superClass, tab + 1, builder, object, true, childLevel, parsers);
                superClass = superClass.getSuperclass();
            }
            return builder.toString();
        }
        return object.toString();
    }

    public static boolean isArray(Object object) {
        return object.getClass().isArray();
    }

    public static String parseArray(Object array, int tab, List<IParser> parsers) {
        StringBuilder result = new StringBuilder();
        LoggerTransform.traverseArray(result, array, tab, parsers);
        return result.toString();
    }

    private static void traverseArray(StringBuilder result, Object array, int tab, List<IParser> parsers) {
        if (LoggerTransform.isArray(array)) {
            if (LoggerTransform.getArrayDimension(array) == 1) {
                switch (LoggerTransform.getType(array)) {
                    case 'I': {
                        result.append(Arrays.toString((int[])array));
                        break;
                    }
                    case 'D': {
                        result.append(Arrays.toString((double[])array));
                        break;
                    }
                    case 'Z': {
                        result.append(Arrays.toString((boolean[])array));
                        break;
                    }
                    case 'B': {
                        result.append(Arrays.toString((byte[])array));
                        break;
                    }
                    case 'S': {
                        result.append(Arrays.toString((short[])array));
                        break;
                    }
                    case 'J': {
                        result.append(Arrays.toString((long[])array));
                        break;
                    }
                    case 'F': {
                        result.append(Arrays.toString((float[])array));
                        break;
                    }
                    case 'L': {
                        Object[] objects = (Object[])array;
                        result.append("[");
                        for (int i = 0; i < objects.length; ++i) {
                            result.append(LoggerTransform.transformToString(objects[i], parsers));
                            if (i == objects.length - 1) continue;
                            result.append(",");
                        }
                        result.append(TabUtils.getTabString(tab));
                        result.append("]");
                        break;
                    }
                    default: {
                        result.append(Arrays.toString((Object[])array));
                        break;
                    }
                }
            } else {
                result.append("[");
                for (int i = 0; i < ((Object[])array).length; ++i) {
                    LoggerTransform.traverseArray(result, ((Object[])array)[i], tab + 1, parsers);
                    if (i == ((Object[])array).length - 1) continue;
                    result.append(",");
                }
                result.append(TabUtils.getTabString(tab));
                result.append("]");
            }
        } else {
            result.append("not a array!!");
        }
    }

    public static int getArrayDimension(Object object) {
        int dim = 0;
        for (int i = 0; i < object.toString().length() && object.toString().charAt(i) == '['; ++i) {
            ++dim;
        }
        return dim;
    }

    public static char getType(Object object) {
        if (LoggerTransform.isArray(object)) {
            String str = object.toString();
            return str.substring(str.lastIndexOf("[") + 1, str.lastIndexOf("[") + 2).charAt(0);
        }
        return '\u0000';
    }

    public static boolean isStaticInnerClass(Class cla) {
        int modifiers;
        return cla != null && cla.isMemberClass() && ((modifiers = cla.getModifiers()) & 8) == 8;
    }

    private static void getClassFields(Class cla, int tab, StringBuilder builder, Object o, boolean isSubClass, int childOffset, List<IParser> parsers) {
        if (cla.equals(Object.class)) {
            return;
        }
        if (isSubClass) {
            builder.append(IParser.LINE_SEPARATOR + TabUtils.getTabString(tab) + "=> ");
        }
        builder.append(cla.getSimpleName() + " {");
        Field[] fields = cla.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Object subObject;
            Field field = fields[i];
            field.setAccessible(true);
            if (cla.isMemberClass() && !LoggerTransform.isStaticInnerClass(cla) && i == 0) continue;
            try {
                subObject = field.get(o);
            }
            catch (IllegalAccessException e) {
                subObject = e;
            }
            if (field.getName().equals("$change") || field.getName().equalsIgnoreCase("this$0") || field.getName().equals("serialVersionUID")) continue;
            if (subObject != null) {
                if (subObject instanceof String) {
                    subObject = "\"" + subObject + "\"";
                } else if (subObject instanceof Character) {
                    subObject = "'" + subObject + "'";
                }
                if (childOffset < 3) {
                    subObject = LoggerTransform.transformToString(subObject, parsers, childOffset + 1);
                }
            }
            builder.append(IParser.LINE_SEPARATOR);
            builder.append(TabUtils.getTabString(tab + 1));
            String formatString = "%s = %s";
            builder.append(String.format(formatString, field.getName(), subObject == null ? "null" : subObject.toString()));
        }
        builder.append(IParser.LINE_SEPARATOR);
        builder.append(TabUtils.getTabString(tab));
        builder.append("}");
    }
}

