/*
 * Decompiled with CFR 0.152.
 */
package com.tuacy.logger;

import com.tuacy.logger.bean.LoggerInfo;
import com.tuacy.logger.parse.IParser;
import com.tuacy.logger.parse.impl.BundleParse;
import com.tuacy.logger.parse.impl.CollectionParse;
import com.tuacy.logger.parse.impl.IntentParse;
import com.tuacy.logger.parse.impl.MapParse;
import com.tuacy.logger.parse.impl.ReferenceParse;
import com.tuacy.logger.parse.impl.ThrowableParse;
import com.tuacy.logger.printer.IPrinter;
import com.tuacy.logger.printer.impl.PrettyPrinter;
import java.util.ArrayList;
import java.util.List;

public class LoggerBuild {
    public static final Class<? extends IParser>[] DEFAULT_PARSE_CLASS = new Class[]{BundleParse.class, IntentParse.class, CollectionParse.class, MapParse.class, ThrowableParse.class, ReferenceParse.class};
    private boolean mLogEnable = true;
    private LoggerInfo.LogLevel mLogLevel = LoggerInfo.LogLevel.VERBOSE;
    private String mTag = "Log";
    private List<IParser> mParseList = null;
    private IPrinter mPrinter = PrettyPrinter.getInstance();
    private boolean mShowThreadName = true;
    private boolean mShowStackTrace = true;
    private int mStackCount = 1;

    public LoggerBuild() {
        this.addParserClass(DEFAULT_PARSE_CLASS);
    }

    private LoggerBuild addParserClass(Class<? extends IParser> ... classes) {
        for (Class<? extends IParser> cla : classes) {
            if (this.mParseList == null) {
                this.mParseList = new ArrayList<IParser>();
            }
            try {
                this.mParseList.add(0, cla.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public LoggerBuild addParse(IParser parser) {
        this.mParseList.add(0, parser);
        return this;
    }

    public List<IParser> getParseList() {
        return this.mParseList;
    }

    public LoggerBuild setTag(String tag) {
        this.mTag = tag;
        return this;
    }

    public String getTag() {
        return this.mTag;
    }

    public LoggerBuild setLogLevel(LoggerInfo.LogLevel level) {
        this.mLogLevel = level;
        return this;
    }

    public LoggerInfo.LogLevel getLogLevel() {
        return this.mLogLevel;
    }

    public LoggerBuild setLogEnable(boolean enable) {
        this.mLogEnable = enable;
        return this;
    }

    public boolean isLogEnable() {
        return this.mLogEnable;
    }

    public LoggerBuild setPrinter(IPrinter printer) {
        this.mPrinter = printer;
        return this;
    }

    public IPrinter getPrinter() {
        return this.mPrinter;
    }

    public LoggerBuild setShowThreadName(boolean show) {
        this.mShowThreadName = show;
        return this;
    }

    public boolean isShowThreadName() {
        return this.mShowThreadName;
    }

    public LoggerBuild setShowStackTrace(boolean show) {
        this.mShowStackTrace = show;
        return this;
    }

    public boolean isShowStackTrace() {
        return this.mShowStackTrace;
    }

    public LoggerBuild setStackCount(int count) {
        this.mStackCount = count;
        return this;
    }

    public int getStackCount() {
        return this.mStackCount;
    }
}

