/*
 * Decompiled with CFR 0.152.
 */
package com.tuacy.logger.printer.impl;

import android.text.TextUtils;
import android.util.Log;
import com.tuacy.logger.bean.LoggerInfo;
import com.tuacy.logger.printer.Printer;

public class PrettyPrinter
implements Printer {
    private static final int CHUNK_SIZE = 4000;
    private static final char TOP_LEFT_CORNER = '\u2554';
    private static final char BOTTOM_LEFT_CORNER = '\u255a';
    private static final char MIDDLE_CORNER = '\u255f';
    private static final char HORIZONTAL_DOUBLE_LINE = '\u2551';
    private static final String DOUBLE_DIVIDER = "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String SINGLE_DIVIDER = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String TOP_BORDER = "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String BOTTOM_BORDER = "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String MIDDLE_BORDER = "\u255f\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static PrettyPrinter sInstance;

    private PrettyPrinter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PrettyPrinter getInstance() {
        if (sInstance != null) return sInstance;
        Class<PrettyPrinter> clazz = PrettyPrinter.class;
        synchronized (PrettyPrinter.class) {
            if (sInstance != null) return sInstance;
            sInstance = new PrettyPrinter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    @Override
    public void print(LoggerInfo LoggerInfo2) {
        this.doPrint(LoggerInfo2);
    }

    private synchronized void doPrint(LoggerInfo LoggerInfo2) {
        LoggerInfo.LogLevel logLevel = LoggerInfo2.getLogLevel();
        String tag = LoggerInfo2.getTag();
        this.printTopBorder(logLevel, tag);
        this.printThreadName(logLevel, tag, LoggerInfo2.getThreadName());
        this.printStackTrace(logLevel, tag, LoggerInfo2.getStackTrace(), LoggerInfo2.getStackCount());
        this.printMessage(logLevel, tag, LoggerInfo2.getMessage());
        this.printBottomBorder(logLevel, tag);
    }

    private void printTopBorder(LoggerInfo.LogLevel logLevel, String tag) {
        this.printChunk(logLevel, tag, TOP_BORDER);
    }

    private void printThreadName(LoggerInfo.LogLevel logLevel, String tag, String threadName) {
        if (!TextUtils.isEmpty((CharSequence)threadName)) {
            this.printChunk(logLevel, tag, "\u2551 Thread: " + threadName);
            this.printDivider(logLevel, tag);
        }
    }

    private void printStackTrace(LoggerInfo.LogLevel logLevel, String tag, StackTraceElement[] trace, int methodCount) {
        if (trace == null || trace.length <= 0 || methodCount <= 0) {
            return;
        }
        if (methodCount > trace.length) {
            methodCount = trace.length;
        }
        String level = "";
        for (int i = methodCount - 1; i >= 0; --i) {
            StringBuilder builder = new StringBuilder();
            builder.append("\u2551 ").append(level).append(this.getSimpleClassName(trace[i].getClassName())).append(".").append(trace[i].getMethodName()).append(" ").append(" (").append(trace[i].getFileName()).append(":").append(trace[i].getLineNumber()).append(")");
            level = level + "   ";
            this.printChunk(logLevel, tag, builder.toString());
        }
        this.printDivider(logLevel, tag);
    }

    private String getSimpleClassName(String name) {
        int lastIndex = name.lastIndexOf(".");
        return name.substring(lastIndex + 1);
    }

    private void printMessage(LoggerInfo.LogLevel logLevel, String tag, String message) {
        if (!TextUtils.isEmpty((CharSequence)message)) {
            byte[] bytes = message.getBytes();
            int length = bytes.length;
            if (length <= 4000) {
                this.printContent(logLevel, tag, message);
            } else {
                for (int i = 0; i < length; i += 4000) {
                    int count = Math.min(length - i, 4000);
                    this.printContent(logLevel, tag, new String(bytes, i, count));
                }
            }
        }
    }

    private void printBottomBorder(LoggerInfo.LogLevel logLevel, String tag) {
        this.printChunk(logLevel, tag, BOTTOM_BORDER);
    }

    private void printDivider(LoggerInfo.LogLevel logLevel, String tag) {
        this.printChunk(logLevel, tag, MIDDLE_BORDER);
    }

    private void printContent(LoggerInfo.LogLevel logLevel, String tag, String chunk) {
        String[] lines;
        for (String line : lines = chunk.split(System.getProperty("line.separator"))) {
            this.printChunk(logLevel, tag, "\u2551 " + line);
        }
    }

    private void printChunk(LoggerInfo.LogLevel logLevel, String tag, String chunk) {
        switch (logLevel) {
            case ERROR: {
                Log.e((String)tag, (String)chunk);
                break;
            }
            case INFO: {
                Log.i((String)tag, (String)chunk);
                break;
            }
            case VERBOSE: {
                Log.v((String)tag, (String)chunk);
                break;
            }
            case WARN: {
                Log.w((String)tag, (String)chunk);
                break;
            }
            case ASSERT: {
                Log.wtf((String)tag, (String)chunk);
                break;
            }
            case DEBUG: {
                Log.d((String)tag, (String)chunk);
                break;
            }
            default: {
                Log.d((String)tag, (String)chunk);
            }
        }
    }
}

