/*
 * Decompiled with CFR 0.152.
 */
package com.tuacy.logger;

import android.text.TextUtils;
import com.tuacy.logger.DebugLogger;
import com.tuacy.logger.ILogger;
import com.tuacy.logger.LoggerBuild;
import com.tuacy.logger.LoggerConvert;
import com.tuacy.logger.bean.LoggerInfo;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LoggerImpl
implements ILogger {
    private final LoggerBuild mConfig;

    public LoggerImpl(LoggerBuild config) {
        this.mConfig = config;
    }

    private void log(LoggerInfo.LogLevel logLevel, String tag, String format, Object ... args) {
        this.log(logLevel, tag, String.format(format, args));
    }

    private void log(LoggerInfo.LogLevel logLevel, String tag, Object object) {
        this.log(logLevel, tag, LoggerConvert.objectToString(object, this.mConfig.getParseList()));
    }

    private void log(LoggerInfo.LogLevel logLevel, String tag, String message) {
        if (!this.mConfig.isLogEnable()) {
            return;
        }
        LoggerInfo.Builder builder = new LoggerInfo.Builder(logLevel, tag, message);
        if (this.mConfig.isShowThreadName()) {
            builder.threadName(Thread.currentThread().getName());
        }
        if (this.mConfig.isShowStackTrace()) {
            builder.stackTrace(this.getStackTrace(), this.mConfig.getStackCount());
        }
        this.mConfig.getPrinter().print(builder.build());
    }

    private StackTraceElement[] getStackTrace() {
        StackTraceElement[] allTraces = Thread.currentThread().getStackTrace();
        int unusedCount = this.getUnusedStackCount(allTraces);
        StackTraceElement[] trace = new StackTraceElement[allTraces.length - unusedCount];
        System.arraycopy(allTraces, unusedCount, trace, 0, allTraces.length - unusedCount);
        return trace;
    }

    private int getUnusedStackCount(StackTraceElement[] trace) {
        int MIN_STACK_OFFSET = 2;
        int count = 2;
        for (int i = 2; i < trace.length; ++i) {
            if (DebugLogger.class.getName().equals(trace[i].getClassName()) || LoggerImpl.class.getName().equals(trace[i].getClassName())) {
                ++count;
                continue;
            }
            return count;
        }
        return -1;
    }

    @Override
    public void v(String tag, String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.VERBOSE, tag, args);
        }
    }

    @Override
    public void v(Class<?> clazz, String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.VERBOSE, clazz.getSimpleName(), args);
        }
    }

    @Override
    public void v(String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.VERBOSE, this.mConfig.getTag(), args);
        }
    }

    @Override
    public void v(String tag, Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.VERBOSE, tag, object);
        }
    }

    @Override
    public void v(Class<?> clazz, Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.VERBOSE, clazz.getSimpleName(), object);
        }
    }

    @Override
    public void v(Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.VERBOSE, this.mConfig.getTag(), object);
        }
    }

    @Override
    public void d(String tag, String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.DEBUG, tag, format, args);
        }
    }

    @Override
    public void d(Class<?> clazz, String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.DEBUG, clazz.getSimpleName(), format, args);
        }
    }

    @Override
    public void d(String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.DEBUG, this.mConfig.getTag(), format, args);
        }
    }

    @Override
    public void d(String tag, Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.DEBUG, tag, object);
        }
    }

    @Override
    public void d(Class<?> clazz, Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.DEBUG, clazz.getSimpleName(), object);
        }
    }

    @Override
    public void d(Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.DEBUG, this.mConfig.getTag(), object);
        }
    }

    @Override
    public void i(String tag, String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.INFO, tag, format, args);
        }
    }

    @Override
    public void i(Class<?> clazz, String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.INFO, clazz.getSimpleName(), format, args);
        }
    }

    @Override
    public void i(String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.INFO, this.mConfig.getTag(), format, args);
        }
    }

    @Override
    public void i(String tag, Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.INFO, tag, object);
        }
    }

    @Override
    public void i(Class<?> clazz, Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.INFO, clazz.getSimpleName(), object);
        }
    }

    @Override
    public void i(Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.INFO, this.mConfig.getTag(), object);
        }
    }

    @Override
    public void w(String tag, String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.WARN, tag, format, args);
        }
    }

    @Override
    public void w(Class<?> clazz, String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.WARN, clazz.getSimpleName(), format, args);
        }
    }

    @Override
    public void w(String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.WARN, this.mConfig.getTag(), format, args);
        }
    }

    @Override
    public void w(String tag, Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.WARN, tag, object);
        }
    }

    @Override
    public void w(Class<?> clazz, Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.WARN, clazz.getSimpleName(), object);
        }
    }

    @Override
    public void w(Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.WARN, this.mConfig.getTag(), object);
        }
    }

    @Override
    public void e(String tag, String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.ERROR, tag, format, args);
        }
    }

    @Override
    public void e(Class<?> clazz, String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.ERROR, clazz.getSimpleName(), format, args);
        }
    }

    @Override
    public void e(String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.ERROR, this.mConfig.getTag(), format, args);
        }
    }

    @Override
    public void e(String tag, Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.ERROR, tag, object);
        }
    }

    @Override
    public void e(Class<?> clazz, Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.ERROR, clazz.getSimpleName(), object);
        }
    }

    @Override
    public void e(Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.ERROR, this.mConfig.getTag(), object);
        }
    }

    @Override
    public void wtf(String tag, String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.ASSERT, tag, format, args);
        }
    }

    @Override
    public void wtf(Class<?> clazz, String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.ASSERT, clazz.getSimpleName(), format, args);
        }
    }

    @Override
    public void wtf(String format, Object ... args) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.ASSERT, this.mConfig.getTag(), format, args);
        }
    }

    @Override
    public void wtf(String tag, Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.ASSERT, tag, object);
        }
    }

    @Override
    public void wtf(Class<?> clazz, Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.ASSERT, clazz.getSimpleName(), object);
        }
    }

    @Override
    public void wtf(Object object) {
        if (this.mConfig.isLogEnable()) {
            this.log(LoggerInfo.LogLevel.ASSERT, this.mConfig.getTag(), object);
        }
    }

    @Override
    public void json(String tag, String json) {
        if (this.mConfig.isLogEnable()) {
            int indent = 4;
            if (TextUtils.isEmpty((CharSequence)json)) {
                this.d(tag, (Object)"JSON{json is empty}");
                return;
            }
            try {
                if (json.startsWith("{")) {
                    JSONObject jsonObject = new JSONObject(json);
                    String msg = jsonObject.toString(indent);
                    this.d(tag, (Object)msg);
                } else if (json.startsWith("[")) {
                    JSONArray jsonArray = new JSONArray(json);
                    String msg = jsonArray.toString(indent);
                    this.d(tag, (Object)msg);
                }
            }
            catch (JSONException e) {
                this.e(tag, (Object)(e.toString() + "\n\njson = " + json));
            }
        }
    }

    @Override
    public void json(Class<?> clazz, String json) {
        if (this.mConfig.isLogEnable()) {
            this.json(clazz.getSimpleName(), json);
        }
    }

    @Override
    public void json(String json) {
        if (this.mConfig.isLogEnable()) {
            this.json(this.mConfig.getTag(), json);
        }
    }

    @Override
    public void xml(String tag, String xml) {
        if (this.mConfig.isLogEnable()) {
            if (TextUtils.isEmpty((CharSequence)xml)) {
                this.d(tag, (Object)"XML{xml is empty}");
                return;
            }
            try {
                StreamSource xmlInput = new StreamSource(new StringReader(xml));
                StreamResult xmlOutput = new StreamResult(new StringWriter());
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(xmlInput, xmlOutput);
                this.d(tag, (Object)xmlOutput.getWriter().toString().replaceFirst(">", ">\n"));
            }
            catch (TransformerException e) {
                this.e(tag, (Object)(e.toString() + "\n\nxml = " + xml));
            }
        }
    }

    @Override
    public void xml(Class<?> clazz, String xml) {
        if (this.mConfig.isLogEnable()) {
            this.xml(clazz.getSimpleName(), xml);
        }
    }

    @Override
    public void xml(String xml) {
        if (this.mConfig.isLogEnable()) {
            this.xml(this.mConfig.getTag(), xml);
        }
    }
}

