/*
 * Decompiled with CFR 0.152.
 */
package com.tuacy.logger;

import com.tuacy.logger.parse.IParser;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

public class LoggerConvert {
    public static final int MAX_CHILD_LEVEL = 2;
    private static final String STRING_OBJECT_NULL = "Object[object is null]";

    public static String objectToString(Object object, List<IParser> parsers) {
        return LoggerConvert.objectToString(object, parsers, 0);
    }

    public static String objectToString(Object object, List<IParser> parsers, int childLevel) {
        if (object == null) {
            return STRING_OBJECT_NULL;
        }
        if (parsers != null && parsers.size() > 0) {
            for (IParser parser : parsers) {
                if (!parser.parseClassType().isAssignableFrom(object.getClass())) continue;
                return parser.parseString(object, parsers);
            }
        }
        if (LoggerConvert.isArray(object)) {
            return LoggerConvert.parseArray(object, parsers);
        }
        if (object.toString().startsWith(object.getClass().getName() + "@")) {
            StringBuilder builder = new StringBuilder();
            LoggerConvert.getClassFields(object.getClass(), builder, object, false, childLevel, parsers);
            Class<?> superClass = object.getClass().getSuperclass();
            while (!superClass.equals(Object.class)) {
                LoggerConvert.getClassFields(superClass, builder, object, true, childLevel, parsers);
                superClass = superClass.getSuperclass();
            }
            return builder.toString();
        }
        return object.toString();
    }

    public static boolean isArray(Object object) {
        return object.getClass().isArray();
    }

    public static String parseArray(Object array, List<IParser> parsers) {
        StringBuilder result = new StringBuilder();
        LoggerConvert.traverseArray(result, array, parsers);
        return result.toString();
    }

    private static void traverseArray(StringBuilder result, Object array, List<IParser> parsers) {
        if (LoggerConvert.isArray(array)) {
            if (LoggerConvert.getArrayDimension(array) == 1) {
                switch (LoggerConvert.getType(array)) {
                    case 'I': {
                        result.append(Arrays.toString((int[])array));
                        break;
                    }
                    case 'D': {
                        result.append(Arrays.toString((double[])array));
                        break;
                    }
                    case 'Z': {
                        result.append(Arrays.toString((boolean[])array));
                        break;
                    }
                    case 'B': {
                        result.append(Arrays.toString((byte[])array));
                        break;
                    }
                    case 'S': {
                        result.append(Arrays.toString((short[])array));
                        break;
                    }
                    case 'J': {
                        result.append(Arrays.toString((long[])array));
                        break;
                    }
                    case 'F': {
                        result.append(Arrays.toString((float[])array));
                        break;
                    }
                    case 'L': {
                        Object[] objects = (Object[])array;
                        result.append("[");
                        for (int i = 0; i < objects.length; ++i) {
                            result.append(LoggerConvert.objectToString(objects[i], parsers));
                            if (i == objects.length - 1) continue;
                            result.append(",");
                        }
                        result.append("]");
                        break;
                    }
                    default: {
                        result.append(Arrays.toString((Object[])array));
                        break;
                    }
                }
            } else {
                result.append("[");
                for (int i = 0; i < ((Object[])array).length; ++i) {
                    LoggerConvert.traverseArray(result, ((Object[])array)[i], parsers);
                    if (i == ((Object[])array).length - 1) continue;
                    result.append(",");
                }
                result.append("]");
            }
        } else {
            result.append("not a array!!");
        }
    }

    public static int getArrayDimension(Object object) {
        int dim = 0;
        for (int i = 0; i < object.toString().length() && object.toString().charAt(i) == '['; ++i) {
            ++dim;
        }
        return dim;
    }

    public static char getType(Object object) {
        if (LoggerConvert.isArray(object)) {
            String str = object.toString();
            return str.substring(str.lastIndexOf("[") + 1, str.lastIndexOf("[") + 2).charAt(0);
        }
        return '\u0000';
    }

    public static boolean isStaticInnerClass(Class cla) {
        int modifiers;
        return cla != null && cla.isMemberClass() && ((modifiers = cla.getModifiers()) & 8) == 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getClassFields(Class cla, StringBuilder builder, Object o, boolean isSubClass, int childOffset, List<IParser> parsers) {
        if (cla.equals(Object.class)) {
            return;
        }
        if (isSubClass) {
            builder.append(IParser.LINE_SEPARATOR + IParser.LINE_SEPARATOR + "=> ");
        }
        String breakLine = "";
        builder.append(cla.getSimpleName() + " {");
        Field[] fields = cla.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String formatString;
            Object subObject;
            Field field;
            block22: {
                field = fields[i];
                field.setAccessible(true);
                if (cla.isMemberClass() && !LoggerConvert.isStaticInnerClass(cla) && i == 0) continue;
                subObject = null;
                try {
                    subObject = field.get(o);
                    if (subObject == null) break block22;
                }
                catch (IllegalAccessException e) {
                    block23: {
                        try {
                            subObject = e;
                            if (subObject == null) break block23;
                        }
                        catch (Throwable throwable) {
                            if (subObject != null) {
                                if (!LoggerConvert.isStaticInnerClass(cla) && (field.getName().equals("$change") || field.getName().equalsIgnoreCase("this$0"))) continue;
                                if (subObject instanceof String) {
                                    subObject = "\"" + subObject + "\"";
                                } else if (subObject instanceof Character) {
                                    subObject = "'" + subObject + "'";
                                }
                                if (childOffset < 2) {
                                    subObject = LoggerConvert.objectToString(subObject, parsers, childOffset + 1);
                                }
                            }
                            String formatString2 = breakLine + "%s = %s, ";
                            builder.append(String.format(formatString2, field.getName(), subObject == null ? "null" : subObject.toString()));
                            throw throwable;
                        }
                        if (!LoggerConvert.isStaticInnerClass(cla) && (field.getName().equals("$change") || field.getName().equalsIgnoreCase("this$0"))) continue;
                        if (subObject instanceof String) {
                            subObject = "\"" + subObject + "\"";
                        } else if (subObject instanceof Character) {
                            subObject = "'" + subObject + "'";
                        }
                        if (childOffset < 2) {
                            subObject = LoggerConvert.objectToString(subObject, parsers, childOffset + 1);
                        }
                    }
                    formatString = breakLine + "%s = %s, ";
                    builder.append(String.format(formatString, field.getName(), subObject == null ? "null" : subObject.toString()));
                    continue;
                }
                if (!LoggerConvert.isStaticInnerClass(cla) && (field.getName().equals("$change") || field.getName().equalsIgnoreCase("this$0"))) continue;
                if (subObject instanceof String) {
                    subObject = "\"" + subObject + "\"";
                } else if (subObject instanceof Character) {
                    subObject = "'" + subObject + "'";
                }
                if (childOffset < 2) {
                    subObject = LoggerConvert.objectToString(subObject, parsers, childOffset + 1);
                }
            }
            formatString = breakLine + "%s = %s, ";
            builder.append(String.format(formatString, field.getName(), subObject == null ? "null" : subObject.toString()));
            continue;
        }
        if (builder.toString().endsWith("{")) {
            builder.append("}");
        } else {
            builder.replace(builder.length() - 2, builder.length() - 1, breakLine + "}");
        }
    }
}

