/*
 * Decompiled with CFR 0.152.
 */
package com.tuacy.library.httpdownload;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.tuacy.library.httpdownload.DownloadListener;
import com.tuacy.library.httpdownload.DownloadRequestHelpQueue;
import com.tuacy.library.httpdownload.DownloadUtils;
import com.tuacy.library.httpdownload.SimpleDownloadListener;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;

public class DownloadRequest
implements Comparable<DownloadRequest> {
    private static final String TAG = DownloadRequest.class.getSimpleName();
    private static final String DEFAULT_DIR = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath();
    public static final int STOP = 1;
    public static final int CANCEL = 2;
    public static final int NETWORK_MOBILE = 1;
    public static final int NETWORK_WIFI = 2;
    private int mDownloadId = -1;
    private AtomicInteger mRetryTime = new AtomicInteger(1);
    private int mAllowedNetworkTypes = 0;
    private Context mContext;
    private DownloadState mDownloadState;
    private String mUrl;
    private String mDestinationDir;
    private String mDestinationFilePath;
    private int mProgressInterval;
    private DownloadRequestHelpQueue mDownloadRequestHelpQueue;
    private long mTimestamp = System.currentTimeMillis() / 1000L;
    private Priority mPriority = Priority.NORMAL;
    private int mCanceledOrStop = 0;
    private DownloadListener mDownloadListener;
    private SimpleDownloadListener mSimpleDownloadListener;

    public DownloadRequest() {
        this.mDownloadState = DownloadState.PENDING;
    }

    @Override
    public int compareTo(DownloadRequest other) {
        Priority right;
        Priority left = this.getPriority();
        return left == (right = other.getPriority()) ? (int)(this.mTimestamp - other.mTimestamp) : right.ordinal() - left.ordinal();
    }

    public long getDownloadRequestAddTimestamp() {
        return this.mTimestamp;
    }

    public DownloadRequest setPriority(Priority priority) {
        this.mPriority = priority;
        return this;
    }

    protected Priority getPriority() {
        return this.mPriority;
    }

    public DownloadRequest setDownloadListener(DownloadListener l) {
        this.mDownloadListener = l;
        return this;
    }

    protected DownloadListener getDownloadListener() {
        return this.mDownloadListener;
    }

    public DownloadRequest setSimpleDownloadListener(SimpleDownloadListener sl) {
        this.mSimpleDownloadListener = sl;
        return this;
    }

    protected SimpleDownloadListener getSimpleDownloadListener() {
        return this.mSimpleDownloadListener;
    }

    protected DownloadRequest setDownloadQueue(DownloadRequestHelpQueue queue) {
        this.mDownloadRequestHelpQueue = queue;
        return this;
    }

    protected void setDownloadState(DownloadState state) {
        this.mDownloadState = state;
    }

    protected DownloadState getDownloadState() {
        return this.mDownloadState;
    }

    public DownloadRequest setDownloadId(int downloadId) {
        this.mDownloadId = downloadId;
        return this;
    }

    protected int getDownloadId() {
        return this.mDownloadId;
    }

    public DownloadRequest setRetryTime(int retryTime) {
        this.mRetryTime = new AtomicInteger(retryTime);
        return this;
    }

    protected int getRetryTime() {
        return this.mRetryTime.decrementAndGet();
    }

    public DownloadRequest setProgressInterval(int millisec) {
        this.mProgressInterval = millisec;
        return this;
    }

    protected int getProgressInterval() {
        return this.mProgressInterval;
    }

    public DownloadRequest setAllowedNetworkTypes(Context context, int types) {
        this.mContext = context;
        this.mAllowedNetworkTypes = types;
        return this;
    }

    protected int getAllowedNetworkTypes() {
        return this.mAllowedNetworkTypes;
    }

    protected Context getContext() {
        return this.mContext;
    }

    public DownloadRequest setUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (!url.startsWith("http") && !url.startsWith("https")) {
            throw new IllegalArgumentException("can only download 'HTTP/HTTPS' url");
        }
        this.mUrl = url;
        return this;
    }

    protected String getUrl() {
        return this.mUrl;
    }

    private String getFilePath() {
        String dir = TextUtils.isEmpty((CharSequence)this.mDestinationDir) ? DEFAULT_DIR : this.mDestinationDir;
        return dir + File.separator + DownloadUtils.getFilenameFromHeader(this.mUrl);
    }

    public DownloadRequest setDestFilePath(String filePath) {
        this.mDestinationFilePath = filePath;
        return this;
    }

    public DownloadRequest setDestDirectory(String dir) {
        this.mDestinationDir = dir;
        return this;
    }

    public String getDestFilePath() {
        File file;
        if (TextUtils.isEmpty((CharSequence)this.mDestinationFilePath)) {
            this.mDestinationFilePath = this.getFilePath();
        }
        if ((file = new File(this.mDestinationFilePath)).isDirectory()) {
            Log.w((String)TAG, (String)"the destination file path cannot be directory");
            this.mDestinationFilePath = this.getFilePath();
        } else if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return this.mDestinationFilePath;
    }

    protected String getTmpDestinationPath() {
        return this.getDestFilePath() + ".tmp";
    }

    protected void cancel() {
        this.mCanceledOrStop |= 2;
    }

    protected void cleanCancelOrStopState() {
        this.mCanceledOrStop = 0;
    }

    protected boolean isCanceled() {
        return (this.mCanceledOrStop & 2) == 2;
    }

    protected void stop() {
        this.mCanceledOrStop |= 1;
    }

    protected boolean isStop() {
        return (this.mCanceledOrStop & 1) == 1;
    }

    protected void finish() {
        if (this.mDownloadRequestHelpQueue != null) {
            this.mDownloadRequestHelpQueue.finishDownloadRequest(this);
        }
    }

    public static enum DownloadState {
        INVALID,
        PENDING,
        RUNNING,
        SUCCESSFUL,
        FAILURE;

    }

    public static enum Priority {
        LOW,
        NORMAL,
        HIGH;

    }
}

