/*
 * Decompiled with CFR 0.152.
 */
package com.tuacy.library.httpdownload;

import android.os.Process;
import android.util.Log;
import com.tuacy.library.httpdownload.DownloadDelivery;
import com.tuacy.library.httpdownload.DownloadRequest;
import com.tuacy.library.httpdownload.DownloadUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;

public class DownloadPrioritizedRunnable
implements Runnable,
Comparable<DownloadPrioritizedRunnable> {
    private static final String TAG = DownloadPrioritizedRunnable.class.getSimpleName();
    private static final int SLEEP_BEFORE_DOWNLOAD = 1500;
    private static final int SLEEP_BEFORE_RETRY = 3500;
    private static final int DEFAUL_TIME_OUT = 20000;
    private static final int BUFFER_SIZE = 4096;
    private static final int MAX_REDIRECTION = 5;
    private static final int HTTP_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    private static final int HTTP_TEMP_REDIRECT = 307;
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String LOCATION = "Location";
    private static final String END_OF_STREAM = "unexpected end of stream";
    private static final String DEFAULT_THREAD_NAME = "DownloadDispatcher";
    private static final String IDLE_THREAD_NAME = "DownloadDispatcher-Idle";
    private int mRedirectionCount = 0;
    private long mTotalBytes = 0L;
    private long mLastProgressTimestamp;
    private volatile boolean mQuit = false;
    private DownloadDelivery mDelivery = null;
    private DownloadRequest mRequest = null;

    public DownloadPrioritizedRunnable(DownloadRequest request, DownloadDelivery downloadDelivery) {
        this.mRequest = request;
        this.mDelivery = downloadDelivery;
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        Thread.currentThread().setName(DEFAULT_THREAD_NAME);
        this.mTotalBytes = 0L;
        this.mRedirectionCount = 0;
        this.executeDownload(this.mRequest);
    }

    private void updateState(DownloadRequest request, DownloadRequest.DownloadState state) {
        request.setDownloadState(state);
    }

    private void updateStart(DownloadRequest request, long totalBytes) {
        if (request.getDownloadState() == DownloadRequest.DownloadState.FAILURE) {
            this.updateState(request, DownloadRequest.DownloadState.RUNNING);
            return;
        }
        this.updateState(request, DownloadRequest.DownloadState.RUNNING);
        this.mDelivery.postStart(request, totalBytes);
    }

    private void updateRetry(DownloadRequest request) {
        this.mDelivery.postRetry(request);
    }

    private void updateProgress(DownloadRequest request, long bytesWritten, long totalBytes) {
        long currentTimestamp = System.currentTimeMillis();
        if (bytesWritten != totalBytes && currentTimestamp - this.mLastProgressTimestamp < (long)request.getProgressInterval()) {
            return;
        }
        this.mLastProgressTimestamp = currentTimestamp;
        if (!request.isCanceled()) {
            this.mDelivery.postProgress(request, bytesWritten, totalBytes);
        }
    }

    private void updateSuccess(DownloadRequest request) {
        this.updateState(request, DownloadRequest.DownloadState.SUCCESSFUL);
        request.finish();
        File file = new File(request.getTmpDestinationPath());
        if (file.exists()) {
            file.renameTo(new File(request.getDestFilePath()));
        }
        this.mDelivery.postSuccess(request);
    }

    private void updateFailure(DownloadRequest request, int statusCode, String errMsg) {
        this.updateState(request, DownloadRequest.DownloadState.FAILURE);
        if ((statusCode == 1 || statusCode == 2) && request.getRetryTime() >= 0) {
            block4: {
                try {
                    long bytesWritten = new File(request.getTmpDestinationPath()).length();
                    this.updateProgress(request, bytesWritten, this.mTotalBytes);
                    Thread.sleep(3500L);
                }
                catch (InterruptedException e) {
                    if (!this.mQuit) break block4;
                    request.finish();
                    return;
                }
            }
            if (!request.isCanceled()) {
                this.updateRetry(request);
                this.executeDownload(request);
            }
            return;
        }
        request.finish();
        this.mDelivery.postFailure(request, statusCode, errMsg);
    }

    private void updateCancel(DownloadRequest request) {
        request.finish();
        File file = new File(request.getTmpDestinationPath());
        if (file.exists()) {
            file.delete();
        }
        this.mDelivery.postCancel(request);
    }

    private void updateStop(DownloadRequest request) {
        request.finish();
        this.mDelivery.postStop(request);
    }

    private long getContentLength(HttpURLConnection conn) {
        String transferEncoding = conn.getHeaderField(TRANSFER_ENCODING);
        if (transferEncoding == null || transferEncoding.equalsIgnoreCase("chunked")) {
            return conn.getHeaderFieldInt(CONTENT_LENGTH, -1);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferData(HttpURLConnection conn, DownloadRequest request) throws IOException {
        long contentLength = this.getContentLength(conn);
        if (contentLength == -1L) {
            return;
        }
        InputStream is = null;
        File file = new File(request.getTmpDestinationPath());
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        long bytesWritten = file.length();
        contentLength += bytesWritten;
        if (bytesWritten > 0L) {
            raf.seek(bytesWritten);
        }
        this.mTotalBytes = contentLength;
        this.updateStart(request, contentLength);
        try {
            is = conn.getInputStream();
            if (is != null) {
                byte[] buffer = new byte[4096];
                while (true) {
                    if (Thread.currentThread().isInterrupted()) {
                        Log.i((String)TAG, (String)("thread interrupted, download id: " + request.getDownloadId()));
                        this.updateStop(request);
                        return;
                    }
                    if (request.isCanceled()) {
                        Log.i((String)TAG, (String)("download has canceled, download id: " + request.getDownloadId()));
                        this.updateCancel(request);
                        return;
                    }
                    if (request.isStop()) {
                        Log.i((String)TAG, (String)("download has stop, download id: " + request.getDownloadId()));
                        this.updateStop(request);
                        return;
                    }
                    if (request.getAllowedNetworkTypes() != 0 && !DownloadUtils.isWifi(request.getContext()) && (request.getAllowedNetworkTypes() & 1) == 0) {
                        this.updateFailure(request, 4, "network error");
                        return;
                    }
                    int length = this.readFromInputStream(buffer, is);
                    if (length == -1) {
                        long fileSize = new File(request.getTmpDestinationPath()).length();
                        this.updateProgress(request, fileSize, contentLength);
                        if (fileSize == contentLength) {
                            this.updateSuccess(request);
                        } else {
                            this.updateFailure(request, 1, "file size error");
                        }
                        return;
                    }
                    if (length == Integer.MIN_VALUE) {
                        this.updateFailure(request, 2, "transfer data error");
                        return;
                    }
                    raf.write(buffer, 0, length);
                    this.updateProgress(request, bytesWritten += (long)length, contentLength);
                }
            }
        }
        finally {
            raf.close();
            DownloadPrioritizedRunnable.silentCloseInputStream(is);
        }
    }

    private int readFromInputStream(byte[] buffer, InputStream is) {
        try {
            return is.read(buffer);
        }
        catch (IOException e) {
            if (END_OF_STREAM.equals(e.getMessage())) {
                return -1;
            }
            return Integer.MIN_VALUE;
        }
    }

    private static void silentCloseInputStream(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"cannot close input stream", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeDownload(DownloadRequest request) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        HttpURLConnection conn = null;
        try {
            URL url = new URL(request.getUrl());
            conn = (HttpURLConnection)url.openConnection();
            conn.setInstanceFollowRedirects(false);
            conn.setUseCaches(false);
            conn.setRequestProperty(ACCEPT_ENCODING, "identity");
            conn.setConnectTimeout(20000);
            conn.setReadTimeout(20000);
            File file = new File(request.getTmpDestinationPath());
            if (file.exists()) {
                long breakpoint = file.length();
                conn.setRequestProperty("Range", "bytes=" + breakpoint + "-");
            }
            int statusCode = conn.getResponseCode();
            switch (statusCode) {
                case 200: 
                case 206: {
                    this.transferData(conn, request);
                    return;
                }
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    if (this.mRedirectionCount++ < 5) {
                        Log.i((String)TAG, (String)("redirect for download id: " + request.getDownloadId()));
                        String redirectUrl = conn.getHeaderField(LOCATION);
                        request.setUrl(redirectUrl);
                        this.executeDownload(request);
                        return;
                    } else {
                        this.updateFailure(request, statusCode, "redirect too many times");
                        return;
                    }
                }
                default: {
                    this.updateFailure(request, statusCode, conn.getResponseMessage());
                    return;
                }
            }
        }
        catch (IOException e) {
            this.updateFailure(request, 1, e.getMessage());
            return;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @Override
    public int compareTo(DownloadPrioritizedRunnable another) {
        DownloadRequest.Priority right;
        DownloadRequest.Priority left = this.mRequest.getPriority();
        return left == (right = another.mRequest.getPriority()) ? (int)(this.mRequest.getDownloadRequestAddTimestamp() - another.mRequest.getDownloadRequestAddTimestamp()) : right.ordinal() - left.ordinal();
    }
}

