/*
 * Decompiled with CFR 0.152.
 */
package com.tuacy.library.httpdownload;

import android.os.Handler;
import android.os.Looper;
import com.tuacy.library.concurrent.AndroidExecutors;
import com.tuacy.library.concurrent.PausableExecutorService;
import com.tuacy.library.httpdownload.DownloadDelivery;
import com.tuacy.library.httpdownload.DownloadPrioritizedRunnable;
import com.tuacy.library.httpdownload.DownloadRequest;
import com.tuacy.library.httpdownload.DownloadRequestHelpQueue;

public class DownloadManager {
    private static final int DEFAULT_THREADS = 3;
    public static final int HTTP_INVALID = 1;
    public static final int HTTP_ERROR_SIZE = 2;
    public static final int HTTP_ERROR_NETWORK = 4;
    public static final int HTTP_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    private static DownloadManager mInstance = null;
    private DownloadRequestHelpQueue mDownloadRequestHelpQueue = new DownloadRequestHelpQueue();
    private PausableExecutorService mPausableExecutorService = null;
    private DownloadDelivery mDownloadDelivery = null;

    private DownloadManager(int nThreads) {
        this.mPausableExecutorService = AndroidExecutors.newFixedPriorityExecutor(nThreads);
        this.mDownloadDelivery = new DownloadDelivery(new Handler(Looper.getMainLooper()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownloadManager getInstance() {
        if (null != mInstance) return mInstance;
        Class<DownloadManager> clazz = DownloadManager.class;
        synchronized (DownloadManager.class) {
            if (null != mInstance) return mInstance;
            mInstance = new DownloadManager(3);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownloadManager getInstance(int nThreads) {
        if (null != mInstance) return mInstance;
        Class<DownloadManager> clazz = DownloadManager.class;
        synchronized (DownloadManager.class) {
            if (null != mInstance) return mInstance;
            mInstance = new DownloadManager(nThreads);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public int add(DownloadRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("DownloadRequest cannot be null");
        }
        request.cleanCancelOrStopState();
        if (this.mDownloadRequestHelpQueue.add(request)) {
            DownloadPrioritizedRunnable downloadRunnable = new DownloadPrioritizedRunnable(request, this.mDownloadDelivery);
            this.mPausableExecutorService.execute(downloadRunnable);
            return request.getDownloadId();
        }
        return -1;
    }

    public void cancel(int downloadId) {
        this.mDownloadRequestHelpQueue.cancel(downloadId);
    }

    public void cancel(String url) {
        this.mDownloadRequestHelpQueue.cancel(url);
    }

    public void stop(int downloadId) {
        this.mDownloadRequestHelpQueue.stop(downloadId);
    }

    public void stop(String url) {
        this.mDownloadRequestHelpQueue.stop(url);
    }

    public void cancelAll() {
        this.mDownloadRequestHelpQueue.cancelAll();
    }

    public void stopAll() {
        this.mDownloadRequestHelpQueue.stopAll();
    }

    public void threadPollPause() {
        this.mPausableExecutorService.pause();
    }

    public void threadPollResume() {
        this.mPausableExecutorService.resume();
    }
}

