/*
 * Decompiled with CFR 0.152.
 */
package com.tuacy.library.httpdownload;

import android.os.Handler;
import com.tuacy.library.httpdownload.DownloadRequest;
import java.util.concurrent.Executor;

public class DownloadDelivery {
    private final Executor mDownloadPoster;

    public DownloadDelivery(final Handler handler) {
        this.mDownloadPoster = new Executor(){

            @Override
            public void execute(Runnable command) {
                handler.post(command);
            }
        };
    }

    protected void postStart(final DownloadRequest request, final long totalBytes) {
        this.mDownloadPoster.execute(new Runnable(){

            @Override
            public void run() {
                if (request.getDownloadListener() != null) {
                    request.getDownloadListener().onStart(request.getDownloadId(), request.getUrl(), request.getDestFilePath(), totalBytes);
                }
            }
        });
    }

    protected void postRetry(final DownloadRequest request) {
        this.mDownloadPoster.execute(new Runnable(){

            @Override
            public void run() {
                if (request.getDownloadListener() != null) {
                    request.getDownloadListener().onRetry(request.getDownloadId(), request.getUrl(), request.getDestFilePath());
                }
            }
        });
    }

    protected void postProgress(final DownloadRequest request, final long bytesWritten, final long totalBytes) {
        this.mDownloadPoster.execute(new Runnable(){

            @Override
            public void run() {
                if (request.getDownloadListener() != null) {
                    request.getDownloadListener().onProgress(request.getDownloadId(), request.getUrl(), request.getDestFilePath(), bytesWritten, totalBytes);
                }
            }
        });
    }

    protected void postSuccess(final DownloadRequest request) {
        this.mDownloadPoster.execute(new Runnable(){

            @Override
            public void run() {
                if (request.getDownloadListener() != null) {
                    request.getDownloadListener().onSuccess(request.getDownloadId(), request.getUrl(), request.getDestFilePath());
                }
                if (request.getSimpleDownloadListener() != null) {
                    request.getSimpleDownloadListener().onSuccess(request.getDownloadId(), request.getUrl(), request.getDestFilePath());
                }
            }
        });
    }

    protected void postFailure(final DownloadRequest request, final int statusCode, final String errMsg) {
        this.mDownloadPoster.execute(new Runnable(){

            @Override
            public void run() {
                if (request.getDownloadListener() != null) {
                    request.getDownloadListener().onFailure(request.getDownloadId(), request.getUrl(), request.getDestFilePath(), statusCode, errMsg);
                }
                if (request.getSimpleDownloadListener() != null) {
                    request.getSimpleDownloadListener().onFailure(request.getDownloadId(), request.getUrl(), statusCode, errMsg);
                }
            }
        });
    }

    protected void postCancel(final DownloadRequest request) {
        this.mDownloadPoster.execute(new Runnable(){

            @Override
            public void run() {
                if (request.getDownloadListener() != null) {
                    request.getDownloadListener().onCancel(request.getDownloadId(), request.getUrl(), request.getDestFilePath());
                }
            }
        });
    }

    protected void postStop(final DownloadRequest request) {
        this.mDownloadPoster.execute(new Runnable(){

            @Override
            public void run() {
                if (request.getDownloadListener() != null) {
                    request.getDownloadListener().onStop(request.getDownloadId(), request.getUrl(), request.getDestFilePath());
                }
            }
        });
    }
}

