/*
 * Decompiled with CFR 0.152.
 */
package com.tuacy.library.httpdownload;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class DownloadUtils {
    private static final AtomicInteger REDIRECT_TIME = new AtomicInteger(0);

    protected static boolean isWifi(Context context) {
        if (context == null) {
            return false;
        }
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = manager.getActiveNetworkInfo();
        return info != null && info.getType() == 1;
    }

    private static String getUuid() {
        return UUID.randomUUID().toString().trim().replaceAll("-", "");
    }

    private static String md5(String origin) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(origin.getBytes("UTF-8"));
            BigInteger bi = new BigInteger(1, md.digest());
            return bi.toString(16);
        }
        catch (Exception e) {
            return DownloadUtils.getUuid();
        }
    }

    private static String getFilenameFromUrl(String url) {
        String filename = DownloadUtils.md5(url) + ".down";
        int index = url.lastIndexOf("/");
        if (index > 0) {
            String tmpFilename = url.substring(index);
            int qmarkIndex = tmpFilename.indexOf("?");
            if (qmarkIndex > 0) {
                tmpFilename = tmpFilename.substring(0, qmarkIndex - 1);
            }
            if (tmpFilename.contains(".")) {
                filename = tmpFilename;
            }
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected static String getFilenameFromHeader(String downloadUrl) {
        filename = DownloadUtils.md5(downloadUrl) + ".down";
        conn = null;
        try {
            url = new URL(downloadUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setInstanceFollowRedirects(false);
            statusCode = conn.getResponseCode();
            switch (statusCode) {
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    location = conn.getHeaderField("Location");
                    if (DownloadUtils.REDIRECT_TIME.addAndGet(1) > 5 || TextUtils.isEmpty((CharSequence)location)) {
                        filename = DownloadUtils.getFilenameFromUrl(downloadUrl);
                        ** break;
lbl14:
                        // 1 sources

                    } else {
                        filename = DownloadUtils.getFilenameFromHeader(location);
                        ** break;
                    }
lbl17:
                    // 1 sources

                    break;
                }
                default: {
                    contentDispos = conn.getHeaderField("Content-Disposition");
                    if (!TextUtils.isEmpty((CharSequence)contentDispos)) {
                        index = contentDispos.indexOf("filename");
                        if (index > 0) {
                            filename = contentDispos.substring(index + 10, contentDispos.length() - 1);
                            ** break;
lbl25:
                            // 1 sources

                        } else {
                            filename = DownloadUtils.getFilenameFromUrl(downloadUrl);
                            ** break;
                        }
lbl28:
                        // 1 sources

                    } else {
                        filename = DownloadUtils.getFilenameFromUrl(downloadUrl);
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            var4_7 = filename;
            return var4_7;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            DownloadUtils.REDIRECT_TIME.set(5);
        }
        try {
            filename = URLDecoder.decode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException var3_5) {
            // empty catch block
        }
        return filename;
    }
}

