/*
 * Decompiled with CFR 0.152.
 */
package com.tuacy.library.httpdownload;

import android.text.TextUtils;
import android.util.Log;
import com.tuacy.library.httpdownload.DownloadRequest;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class DownloadRequestHelpQueue {
    private static final String TAG = DownloadRequestHelpQueue.class.getSimpleName();
    private final Set<DownloadRequest> mCurrentRequests = new HashSet<DownloadRequest>();
    private AtomicInteger mSequenceGenerator = new AtomicInteger();

    public int getSequenceNumber() {
        return this.mSequenceGenerator.incrementAndGet();
    }

    protected int getDownloadingSize() {
        return this.mCurrentRequests.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DownloadRequest.DownloadState query(int downloadId) {
        Set<DownloadRequest> set = this.mCurrentRequests;
        synchronized (set) {
            for (DownloadRequest request : this.mCurrentRequests) {
                if (request.getDownloadId() != downloadId) continue;
                return request.getDownloadState();
            }
        }
        return DownloadRequest.DownloadState.INVALID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DownloadRequest.DownloadState query(String url) {
        Set<DownloadRequest> set = this.mCurrentRequests;
        synchronized (set) {
            for (DownloadRequest request : this.mCurrentRequests) {
                if (!request.getUrl().equals(url)) continue;
                return request.getDownloadState();
            }
        }
        return DownloadRequest.DownloadState.INVALID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean add(DownloadRequest request) {
        if (TextUtils.isEmpty((CharSequence)request.getUrl())) {
            Log.w((String)TAG, (String)"download url cannot be empty");
            return false;
        }
        if (request.getDownloadId() == -1) {
            int downloadId = this.getSequenceNumber();
            request.setDownloadId(downloadId);
        }
        if (this.query(request.getDownloadId()) != DownloadRequest.DownloadState.INVALID || this.query(request.getUrl()) != DownloadRequest.DownloadState.INVALID) {
            Log.w((String)TAG, (String)"the download request is in downloading");
            return false;
        }
        request.setDownloadQueue(this);
        Set<DownloadRequest> set = this.mCurrentRequests;
        synchronized (set) {
            this.mCurrentRequests.add(request);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        Set<DownloadRequest> set = this.mCurrentRequests;
        synchronized (set) {
            for (DownloadRequest request : this.mCurrentRequests) {
                request.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Set<DownloadRequest> set = this.mCurrentRequests;
        synchronized (set) {
            for (DownloadRequest request : this.mCurrentRequests) {
                request.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int downloadId) {
        Set<DownloadRequest> set = this.mCurrentRequests;
        synchronized (set) {
            for (DownloadRequest request : this.mCurrentRequests) {
                if (request.getDownloadId() != downloadId) continue;
                request.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(String url) {
        Set<DownloadRequest> set = this.mCurrentRequests;
        synchronized (set) {
            for (DownloadRequest request : this.mCurrentRequests) {
                if (!request.getUrl().equals(url)) continue;
                request.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(int downloadId) {
        Set<DownloadRequest> set = this.mCurrentRequests;
        synchronized (set) {
            for (DownloadRequest request : this.mCurrentRequests) {
                if (request.getDownloadId() != downloadId) continue;
                request.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String url) {
        Set<DownloadRequest> set = this.mCurrentRequests;
        synchronized (set) {
            for (DownloadRequest request : this.mCurrentRequests) {
                if (!request.getUrl().equals(url)) continue;
                request.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishDownloadRequest(DownloadRequest request) {
        Set<DownloadRequest> set = this.mCurrentRequests;
        synchronized (set) {
            this.mCurrentRequests.remove(request);
        }
    }
}

