/*
 * Decompiled with CFR 0.152.
 */
package com.tuacy.library.concurrent;

public abstract class SafeRunnable
implements Runnable {
    private static final int RETRY_LIMIT = 3;

    protected abstract void onRun() throws Throwable;

    protected void onStart() {
    }

    protected void onComplete() {
    }

    protected void onInterrupt() {
    }

    protected void onFailed() {
    }

    protected abstract RunnableState getStateByThrowable(Throwable var1);

    protected int getRetryLimit() {
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean safeRun(int currentRunCount) {
        boolean ret = true;
        RunnableState state = RunnableState.STATE_COMPLETE;
        this.onStart();
        try {
            this.onRun();
        }
        catch (Throwable t) {
            state = this.getStateByThrowable(t);
            if (RunnableState.STATE_RETRY == state) {
                state = currentRunCount < this.getRetryLimit() ? RunnableState.STATE_RETRY : RunnableState.STATE_FAILED;
            }
        }
        finally {
            try {
                switch (state) {
                    case STATE_COMPLETE: {
                        this.onComplete();
                        break;
                    }
                    case STATE_RETRY: {
                        ret = false;
                        break;
                    }
                    case STATE_INTERRUPT: {
                        this.onInterrupt();
                        break;
                    }
                    case STATE_FAILED: {
                        this.onFailed();
                    }
                }
            }
            catch (Throwable ignored) {}
        }
        return ret;
    }

    @Override
    public void run() {
        int runCount = 0;
        while (!this.safeRun(runCount)) {
            ++runCount;
        }
    }

    public static enum RunnableState {
        STATE_COMPLETE,
        STATE_RETRY,
        STATE_INTERRUPT,
        STATE_FAILED;

    }
}

