/*
 * Decompiled with CFR 0.152.
 */
package com.tuacy.library.concurrent;

import com.tuacy.library.concurrent.AndroidThreadPool;
import com.tuacy.library.concurrent.PausableExecutorService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AndroidExecutors {
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    static final int MAX_POOL_SIZE = CPU_COUNT * 2 + 1;
    static final long KEEP_ALIVE_TIME = 1L;

    public static PausableExecutorService newSingleThreadExecutor() {
        return new FinalizableDelegatedExecutorService(new AndroidThreadPool(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public static PausableExecutorService newSinglePriorityExecutor() {
        return new FinalizableDelegatedExecutorService(new AndroidThreadPool(1, 1, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>()));
    }

    public static PausableExecutorService newFixedPriorityExecutor(int nThreads) {
        return new FinalizableDelegatedExecutorService(new AndroidThreadPool(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>()));
    }

    public static PausableExecutorService newCachedThreadPool() {
        return new AndroidThreadPool(CORE_POOL_SIZE, MAX_POOL_SIZE, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static PausableExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return new AndroidThreadPool(CORE_POOL_SIZE, MAX_POOL_SIZE, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    static class FinalizableDelegatedExecutorService
    extends DelegatedExecutorService {
        FinalizableDelegatedExecutorService(PausableExecutorService executor) {
            super(executor);
        }

        protected void finalize() {
            super.shutdown();
        }
    }

    static class DelegatedExecutorService
    extends AbstractExecutorService
    implements PausableExecutorService {
        private final PausableExecutorService e;

        DelegatedExecutorService(PausableExecutorService executor) {
            this.e = executor;
        }

        @Override
        public void execute(Runnable command) {
            this.e.execute(command);
        }

        @Override
        public void shutdown() {
            this.e.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.e.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.e.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.e.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.awaitTermination(timeout, unit);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.e.submit(task);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.e.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.e.submit(task, result);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.e.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.e.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.e.invokeAny(tasks, timeout, unit);
        }

        @Override
        public void pause() {
            this.e.pause();
        }

        @Override
        public void resume() {
            this.e.resume();
        }

        @Override
        public boolean isPause() {
            return this.e.isPause();
        }
    }
}

