/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor;

import android.content.Intent;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import com.tts.android.aopmonitor.R;
import com.tts.android.aopmonitor.RecordService;
import com.tts.android.aopmonitor.bean.ViewClickAction;
import com.tts.android.aopmonitor.tools.Constants;
import com.tts.android.aopmonitor.tools.LogUtils;
import com.tts.android.aopmonitor.tools.TimeUtils;
import java.io.Serializable;

public class AOPMonitorUtil {
    public static void setExtendData(View view, String extend) {
        view.setTag(R.id.aopmonitor_extend, (Object)extend);
    }

    public static void setDescription(View view, String des) {
        view.setContentDescription((CharSequence)des);
    }

    public static void setUserId(String userId) {
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            Constants.userId = userId;
            if (null != Constants.appContext) {
                // empty if block
            }
        }
    }

    public static void setLatitude(String latitude) {
        Constants.latitude = latitude;
    }

    public static void setAltitude(String altitude) {
        Constants.altitude = altitude;
    }

    public static void addRecordToView(View v) {
        v.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
    }

    public static void addRecordToView(View v, Class cls) {
        if (cls == EditText.class) {
            AOPMonitorUtil.setExtendData(v, ((EditText)v).getText().toString());
        }
        AOPMonitorUtil.addRecordToView(v);
    }

    public static void sendOneRecord(String pageId, String widgetId, String extend) {
        if (null == Constants.appContext) {
            LogUtils.loge("cannot send a record, AOPMonitor is not inited");
            return;
        }
        ViewClickAction action = new ViewClickAction();
        action.setWidgetId(TextUtils.isEmpty((CharSequence)widgetId) ? "" : widgetId);
        action.setPageId(TextUtils.isEmpty((CharSequence)pageId) ? "" : pageId);
        action.setExtend(TextUtils.isEmpty((CharSequence)extend) ? "" : extend);
        action.setTimeStamp(TimeUtils.getTimeStamp());
        Intent intent = new Intent();
        intent.setAction("com.record");
        intent.putExtra("type", 1001);
        intent.putExtra("data", (Serializable)action);
        Constants.appContext.sendBroadcast(intent);
    }

    public static boolean isRecordServiceAlive() {
        return RecordService.isServiceRunning();
    }
}

