package com.tts.android.aopmonitor.tools;

import android.content.Context;

import java.util.HashMap;
import java.util.Properties;

/**
 * properties管理
 * @author shijianting
 * 2018/11/27 9:03 AM
 */
public class PropertiesUtil {

    /**
     * 从assets打开properties文件
     * @param c
     * @param propertiesFile
     * @param key
     * @return
     */
    public static String getPropertiesURL(Context c, String propertiesFile, String key) {
        String content = null;
        Properties properties = new Properties();
        try {
            properties.load(c.getAssets().open(propertiesFile+".properties"));
            content = properties.getProperty(key);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    /**
     * 遍历properties文件所有属性
     * @param c
     * @param propertiesFile
     * @return
     */
    public static HashMap<String, String> getAllProperties(Context c, String propertiesFile) {
        Properties properties = new Properties();
        HashMap<String, String> keyValues = new HashMap<>();
        try {
            properties.load(c.getAssets().open(propertiesFile+".properties"));
                for (String key : properties.stringPropertyNames()) {
                    keyValues.put(key, properties.getProperty(key));
                }
        }catch (Exception e) {
            e.printStackTrace();
        }
        return keyValues;
    }
}
