/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor.aspect;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;
import com.tts.android.aopmonitor.AOPMonitorUtil;
import com.tts.android.aopmonitor.R;
import com.tts.android.aopmonitor.annotation.NoBindMonitor;
import com.tts.android.aopmonitor.annotation.PageStatistics;
import com.tts.android.aopmonitor.bean.ViewClickAction;
import com.tts.android.aopmonitor.tools.Constants;
import com.tts.android.aopmonitor.tools.LogUtils;
import com.tts.android.aopmonitor.tools.TimeUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class ClickRecordAspect {
    private final String POINT_CONTENT = "execution(@com.tts.android.aopmonitor.annotation.BindMonitor * *(..))";
    private final String POINT_ALL_ONCLICK = "execution(* android.view.View.OnClickListener.onClick(..))";
    private final String POINT_ALL_ITEMONCLICK = "execution(* android.widget.AdapterView.OnItemClickListener.onItemClick(..))";
    private final String POINT_ALL_CHECK = "execution(* android.widget.CompoundButton.OnCheckedChangeListener.onCheckedChanged(..))";

    @Pointcut(value="execution(@com.tts.android.aopmonitor.annotation.BindMonitor * *(..))")
    public void unKnownClickMethod() {
    }

    @Pointcut(value="execution(* android.view.View.OnClickListener.onClick(..))")
    public void allOnClickMethod() {
    }

    @Pointcut(value="execution(* android.widget.AdapterView.OnItemClickListener.onItemClick(..))")
    public void allItemOnClickMethod() {
    }

    @Pointcut(value="execution(* android.widget.CompoundButton.OnCheckedChangeListener.onCheckedChanged(..))")
    public void allCheckChangeMethod() {
    }

    @After(value="allOnClickMethod()")
    public void clickRecord(JoinPoint point) throws Throwable {
        if (!this.isEnabledMonitor(point)) {
            return;
        }
        View v = this.getArgView(point);
        this.executeRecord(v);
    }

    @After(value="allItemOnClickMethod()")
    public void itemClickRecord(JoinPoint point) throws Throwable {
        if (!this.isEnabledMonitor(point)) {
            return;
        }
        View v = this.getArgView(point);
        this.executeRecord(v);
    }

    @After(value="allCheckChangeMethod()")
    public void checkChangeRecord(JoinPoint point) throws Throwable {
        Object[] args;
        if (!this.isEnabledMonitor(point)) {
            return;
        }
        View v = this.getArgView(point);
        Boolean checked = null;
        for (Object obj : args = point.getArgs()) {
            if (!(obj instanceof Boolean)) continue;
            checked = (Boolean)obj;
        }
        if (null != checked) {
            if (null != v.getTag(R.id.aopmonitor_extend) && !TextUtils.isEmpty((CharSequence)v.getTag(R.id.aopmonitor_extend).toString())) {
                String extend = v.getTag(R.id.aopmonitor_extend).toString();
                extend = extend.replace("true", "");
                extend = extend.replace("false", "");
                extend = extend.replace("&", "");
                extend = extend + checked + "";
                AOPMonitorUtil.setExtendData(v, extend);
            } else {
                AOPMonitorUtil.setExtendData(v, checked + "");
            }
        }
        this.executeRecord(v);
    }

    @After(value="unKnownClickMethod()")
    public void unknownViewClickRecord(JoinPoint point) {
        if (!this.isEnabledMonitor(point)) {
            return;
        }
        View v = this.getArgView(point);
        this.executeRecord(v);
    }

    public boolean isEnabledMonitor(JoinPoint point) {
        NoBindMonitor aspectFlag;
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        if (!Constants.enabledMonitor) {
            return false;
        }
        if (null == method) {
            LogUtils.loge("can't get the method by reflect");
        }
        return (aspectFlag = method.getAnnotation(NoBindMonitor.class)) == null;
    }

    public void executeRecord(View v) {
        String extend = "";
        if (null != v) {
            try {
                if (null != v.getTag(R.id.aopmonitor_extend)) {
                    extend = v.getTag(R.id.aopmonitor_extend).toString();
                }
                Context c = v.getContext();
                String description = (String)v.getContentDescription();
                String page = ClickRecordAspect.getPageName(c);
                String viewId = "";
                if (!TextUtils.isEmpty((CharSequence)description)) {
                    viewId = description;
                } else if (v.getId() != -1) {
                    viewId = c.getResources().getResourceEntryName(v.getId());
                } else {
                    LogUtils.loge(String.format("this %s have no id, in %s ! \n it's a necessary param", v.getClass().getName().toString(), page));
                }
                ViewClickAction action = this.getClickAction(page, viewId, extend);
                this.sendAction(c, action);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            LogUtils.loge("the method has no view param or the params are incorrect");
        }
    }

    public static String getPageName(Context context) {
        String pageName = "";
        PageStatistics bindPageName = context.getClass().getAnnotation(PageStatistics.class);
        pageName = null != bindPageName && !TextUtils.isEmpty((CharSequence)bindPageName.value()) ? bindPageName.value() : (null != bindPageName && bindPageName.name() != -1 ? context.getString(bindPageName.name()) : ((Activity)context).getComponentName().getClassName());
        return pageName;
    }

    public void sendAction(Context context, ViewClickAction action) {
        Intent intent = new Intent();
        intent.setAction("com.record");
        intent.putExtra("type", 1001);
        intent.putExtra("data", (Serializable)action);
        context.sendBroadcast(intent);
    }

    public View getArgView(JoinPoint point) {
        Object[] args;
        for (Object obj : args = point.getArgs()) {
            if (!(obj instanceof View)) continue;
            return (View)obj;
        }
        return null;
    }

    public ViewClickAction getClickAction(String pageId, String widgetId, String extend) {
        ViewClickAction action = new ViewClickAction();
        action.setWidgetId(TextUtils.isEmpty((CharSequence)widgetId) ? "" : widgetId);
        action.setPageId(TextUtils.isEmpty((CharSequence)pageId) ? "" : pageId);
        action.setExtend(TextUtils.isEmpty((CharSequence)extend) ? "" : extend);
        action.setTimeStamp(TimeUtils.getTimeStamp());
        return action;
    }
}

