/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor.tools;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.text.TextUtils;
import com.tts.android.aopmonitor.actmanager.ActivityResultCallBack;
import com.tts.android.aopmonitor.actmanager.ActivityStartResultManager;
import com.tts.android.aopmonitor.tools.LogUtils;

public class ContactUtils {
    public static void executeGetContact(final Context context, final ContactListener listener) throws Exception {
        if (null == context || !(context instanceof Activity)) {
            LogUtils.loge("param is null, or context is not a activity");
            return;
        }
        ActivityStartResultManager.get().from((Activity)context).action("android.intent.action.PICK").uri(ContactsContract.Contacts.CONTENT_URI).startForResult(new ActivityResultCallBack(){

            @Override
            public void onResultError() {
                listener.fail("can not open the system contact");
            }

            @Override
            public void onActivityResult(int resultCode, Intent data) {
                if (-1 == resultCode) {
                    ContentResolver contentResolver = context.getApplicationContext().getContentResolver();
                    Uri contactData = data.getData();
                    Cursor cursor = context.getApplicationContext().getContentResolver().query(contactData, null, null, null, null);
                    cursor.moveToFirst();
                    String username = cursor.getString(cursor.getColumnIndex("display_name"));
                    String contactId = cursor.getString(cursor.getColumnIndex("_id"));
                    cursor.close();
                    Cursor phoneCursor = contentResolver.query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, null, "_id = " + contactId, null, null, null);
                    String usernumber1 = null;
                    while (phoneCursor.moveToNext()) {
                        usernumber1 = phoneCursor.getString(phoneCursor.getColumnIndex("data1"));
                    }
                    phoneCursor.close();
                    if (!TextUtils.isEmpty((CharSequence)username) && !TextUtils.isEmpty((CharSequence)usernumber1)) {
                        listener.success(username, usernumber1);
                    } else {
                        listener.fail("cannot support your android os");
                    }
                }
            }
        });
    }

    public static interface ContactListener {
        public void success(String var1, String var2);

        public void fail(String var1);
    }
}

