/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor.aspect;

import com.tts.android.aopmonitor.tools.Constants;
import com.tts.android.aopmonitor.tools.LogUtils;
import com.tts.android.aopmonitor.tools.MultipleClickLimitUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class MultiClickAspect {
    private final String POINT_CONTENT = "execution(@com.tts.android.aopmonitor.annotation.BindMultiClick * *(..))";

    @Pointcut(value="execution(@com.tts.android.aopmonitor.annotation.BindMultiClick * *(..))")
    public void multiClick() {
    }

    @Around(value="multiClick()")
    public void multiClickAround(ProceedingJoinPoint point) throws Throwable {
        if (!MultipleClickLimitUtils.isDoubleClick(Constants.options.getMultiClickDuring())) {
            point.proceed();
        } else {
            LogUtils.logd("\u8fd9\u662f\u4e00\u6b21\u91cd\u590d\u70b9\u51fb");
        }
    }
}

