/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.blankj.utilcode.util.AppUtils;
import com.blankj.utilcode.util.CacheDiskUtils;
import com.blankj.utilcode.util.DeviceUtils;
import com.blankj.utilcode.util.PhoneUtils;
import com.blankj.utilcode.util.ScreenUtils;
import com.google.gson.Gson;
import com.tts.android.aopmonitor.bean.ViewClickAction;
import com.tts.android.aopmonitor.net.NetManager;
import com.tts.android.aopmonitor.net.bean.RecordRequestBean;
import com.tts.android.aopmonitor.tools.Constants;
import com.tts.android.aopmonitor.tools.CtwUtils;
import com.tts.android.aopmonitor.tools.LogUtils;
import com.tts.android.aopmonitor.tools.TimeUtils;
import java.util.ArrayList;

public class RecordService
extends Service {
    private static volatile RecordService service;
    private BroadcastReceiver receiver;
    private ArrayList<ViewClickAction> actions = new ArrayList();
    private RecordSendHandler handler;
    private final int HANDLER_TAG = 90001;
    public static final String RECORD_TAG = "com.record";
    public static final String ACTION_TYPE = "type";
    public static final String DATA = "data";
    public static final String PAGE = "page";
    public static final int ACTION_RECORD = 1001;
    public static final int PAGE_RECORD = 1002;
    public static final String CHANNEL_ID_STRING = "ct_trip";

    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    public void onCreate() {
        super.onCreate();
        NotificationManager notificationManager = (NotificationManager)this.getApplication().getSystemService("notification");
        NotificationChannel mChannel = null;
        if (Build.VERSION.SDK_INT >= 26) {
            mChannel = new NotificationChannel(CHANNEL_ID_STRING, (CharSequence)"\u7545\u9014\u7f51", 1);
            notificationManager.createNotificationChannel(mChannel);
            Notification notification = new Notification.Builder(this.getApplicationContext(), CHANNEL_ID_STRING).build();
            this.startForeground(1, notification);
        }
        service = this;
        LogUtils.logd("RecordService\u542f\u52a8\u4e86");
        this.handler = new RecordSendHandler();
        this.receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                int type = intent.getIntExtra(RecordService.ACTION_TYPE, 0);
                switch (type) {
                    case 1001: {
                        ViewClickAction action = (ViewClickAction)intent.getSerializableExtra(RecordService.DATA);
                        if (null == action) break;
                        RecordService.this.actions.add(action);
                        RecordService.this.checkActions();
                        break;
                    }
                    case 1002: {
                        String page = intent.getStringExtra(RecordService.PAGE);
                        RecordRequestBean bean = new RecordRequestBean();
                        bean = RecordService.initBaseRecordBean(bean);
                        bean.setPageId(page);
                        String actionStr = new Gson().toJson((Object)CtwUtils.initCtwRecordBean(bean));
                        RecordService.this.putOneActionInHandler(actionStr);
                        break;
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction(RECORD_TAG);
        this.registerReceiver(this.receiver, filter);
        this.resendDiskRecord();
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public boolean bindService(Intent service, ServiceConnection conn, int flags) {
        return super.bindService(service, conn, flags);
    }

    public void onDestroy() {
        super.onDestroy();
        service = null;
        LogUtils.logd("RecordService\u5173\u95ed\u4e86");
        this.unregisterReceiver(this.receiver);
    }

    private void resendDiskRecord() {
        if (CacheDiskUtils.getInstance().getCacheCount() > 0) {
            String action;
            int i = 0;
            while (!TextUtils.isEmpty((CharSequence)(action = CacheDiskUtils.getInstance().getString("r" + i, "")))) {
                this.putOneActionInHandler(action);
                CacheDiskUtils.getInstance().remove("r" + i);
                ++i;
            }
            String crashInfo = CacheDiskUtils.getInstance().getString("crash", "");
            if (!TextUtils.isEmpty((CharSequence)crashInfo)) {
                this.putOneActionInHandler(crashInfo);
                CacheDiskUtils.getInstance().remove("crash");
            }
            LogUtils.logd("disk cache record have been send");
        } else {
            LogUtils.logd("have no disk cache records");
        }
    }

    private void checkActions() {
        if (this.actions.size() >= Constants.moniterOption.getActionCount()) {
            RecordRequestBean bean = new RecordRequestBean();
            bean = RecordService.initBaseRecordBean(bean);
            bean.setActions(this.actions);
            String actionStr = new Gson().toJson((Object)CtwUtils.initCtwRecordBean(bean));
            this.putOneActionInHandler(actionStr);
            this.actions.clear();
        }
    }

    private void putOneActionInHandler(String action) {
        Message msg = Message.obtain();
        msg.what = 90001;
        msg.obj = action;
        this.handler.sendMessage(msg);
    }

    @SuppressLint(value={"MissingPermission"})
    public static RecordRequestBean initBaseRecordBean(RecordRequestBean bean) {
        bean.setAppVersionCode(AppUtils.getAppVersionCode() + "");
        bean.setAppVersionName(AppUtils.getAppVersionName());
        bean.setFlowCode(Constants.random32String);
        bean.setUniqueId(PhoneUtils.getDeviceId());
        bean.setTimeStamp(TimeUtils.getTimeStamp());
        bean.setOrderSource("android");
        bean.setChannel("7");
        bean.setUserId(Constants.userId);
        bean.setLatitude(Constants.latitude);
        bean.setAltitude(Constants.altitude);
        bean.setSystemVersion(DeviceUtils.getSDKVersionName());
        bean.setManufacturer(Build.MANUFACTURER);
        bean.setModel(Build.MODEL);
        bean.setResolution(ScreenUtils.getScreenHeight() + "x" + ScreenUtils.getScreenWidth());
        return bean;
    }

    public static boolean isServiceRunning() {
        return service != null;
    }

    private class RecordSendHandler
    extends Handler {
        private RecordSendHandler() {
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 90001 && null != msg.obj) {
                String action = msg.obj.toString();
                NetManager.getInstance((Context)RecordService.this).doRecord(action);
            }
        }
    }
}

