package com.tts.android.aopmonitor.aspect;


import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.tts.android.aopmonitor.AOPMonitor;
import com.tts.android.aopmonitor.RecordService;
import com.tts.android.aopmonitor.bean.ViewClickAction;
import com.tts.android.aopmonitor.tools.LogUtils;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

/**
 * 记录webview通过js发送的action
 * @author shijianting
 * 2018/11/16 12:50 PM
 */
@Aspect
public class WebRecordAspect {

    @Pointcut("execution(@com.tts.android.aopmonitor.annotation.WebRecord * *(..))")
    public void webRecord() {}

    @After("webRecord()")
    public void doWebRecord(JoinPoint point) {

        Object[] args = point.getArgs();
        String actionJson = "";
        Context context = null;
        if (args.length == 1) {
            if (args[0] instanceof String) {
                actionJson = String.valueOf(args[0]);
            }
        }
        //使用初始化传入的Application的context
        if (AOPMonitor.mContext != null) {
            context = AOPMonitor.mContext;
        }
        else {
            LogUtils.loge("AOPMonitor is not inited");
            return;
        }

        if (!TextUtils.isEmpty(actionJson)) {
            try {
                ViewClickAction action = new Gson().fromJson(actionJson, ViewClickAction.class);
                sendAction(context, action);
            }
            catch (Exception e) {
                LogUtils.loge("the webview actionjson has not a correct format");
            }
        }
        else {
            LogUtils.loge("the method has no String argument");
        }
    }

    /**
     * 发送手机的数据广播
     * @param context activity的引用
     * @param action 动作
     */
    public void sendAction(Context context, ViewClickAction action) {
        Intent intent = new Intent();
        intent.setAction(RecordService.RECORD_TAG);
        intent.putExtra(RecordService.ACTION_TYPE, RecordService.ACTION_RECORD);
        intent.putExtra(RecordService.DATA, action);
        context.sendBroadcast(intent);
    }
}
