package com.tts.android.aopmonitor.actmanager;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;

import com.tts.android.aopmonitor.tools.LogUtils;
import com.tts.push.PageCenter;

/**
 * url页面跳转管理
 * @author shijianting
 * 2018/12/15 4:38 PM
 */
public class Navigation {

    public Context context;

    public String url;

    public Bundle data;

    public Navigation(Context context) {
        this.context = context;
    }

    /**
     * 跳转
     */
    public void jump() {
        Class targetPage = null;
        if (!TextUtils.isEmpty(url) && PageCenter.mPages.containsKey(url)) {
            targetPage = PageCenter.mPages.get(url).getAct();
        }
        if (null == targetPage) {
            LogUtils.loge("activity target is null");
            return;
        }
        Intent intent = new Intent(context, targetPage);
        if (null != data) {
            intent.putExtra("data", data);
        }
        context.startActivity(intent);
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Bundle getData() {
        return data;
    }

    public void setData(Bundle data) {
        this.data = data;
    }

    public static class Builder {

        public Navigation target;

        public Builder(Context context) {
            target = new Navigation(context);
        }

        public Builder url(String url) {
            target.setUrl(url);
            return this;
        }

        public Builder data(Bundle bundle) {
            target.setData(bundle);
            return this;
        }

        public Navigation build() {
            return target;
        }
    }
}
