/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.google.gson.Gson;
import com.tts.android.aopmonitor.AOPOptions;
import com.tts.android.aopmonitor.RecordService;
import com.tts.android.aopmonitor.bean.InitRecordBean;
import com.tts.android.aopmonitor.options.MoniterOption;
import com.tts.android.aopmonitor.tools.Constants;
import com.tts.android.aopmonitor.tools.CtwUtils;
import com.tts.android.aopmonitor.tools.LogUtils;
import com.tts.android.aopmonitor.tools.StringUtils;

public class AOPMonitor {
    public static Context mContext;

    public static void init(Context context) {
        Constants.appContext = mContext = context.getApplicationContext();
        Constants.random32String = StringUtils.getRandomString(32);
        LogUtils.initLogger();
    }

    public static void init(Context context, AOPOptions options) {
        AOPMonitor.init(context);
        Constants.options = options;
    }

    public static void setDebug(boolean debug) {
        if (Constants.options != null) {
            Constants.options.setDebug(debug);
        }
    }

    @Deprecated
    public static <T extends InitRecordBean> void initRecordData(T bean) {
        if (bean instanceof InitRecordBean) {
            Constants.initRecord = new Gson().toJson((Object)CtwUtils.initCtwRecordBean(bean));
        }
    }

    public static void setOption(AOPOptions options) {
        Constants.options = options;
    }

    public static void setMonitorOption(MoniterOption option) {
        Constants.moniterOption = option;
    }

    public static void startRecordService() {
        if (null != mContext) {
            if (Build.VERSION.SDK_INT >= 26) {
                mContext.startForegroundService(new Intent(mContext, RecordService.class));
            } else {
                mContext.startService(new Intent(mContext, RecordService.class));
            }
        }
    }

    public static void stopRecordService() {
        if (null != mContext) {
            Intent intent = new Intent(mContext, RecordService.class);
            mContext.stopService(intent);
        }
    }

    public static void setEnableMonitor(boolean enabled) {
        Constants.enabledMonitor = enabled;
    }

    public static void onDestroy(Context context) {
    }
}

