package com.tts.android.aopmonitor.tools;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 时间管理
 * @author shijianting
 * 2018/11/27 9:02 AM
 */
public class TimeUtils {

    /**
     * 获取当前时间，格式：年月日时分秒毫秒
     *
     * @return the date
     */
    public static String getDate() {
        try {
            return new SimpleDateFormat("yyyyMMddHHmmssSSS").format(System.currentTimeMillis());
        } catch (Exception e) {

        }
        return String.valueOf(System.currentTimeMillis());
    }

    /**
     * 获取当前系统时间到毫秒
     * @return
     */
    public static String getCurrentDateTimeHS() {
        SimpleDateFormat dfs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return dfs.format(new Date());
    }

    /**
     * 获取long型时间戳
     * @return
     */
    public static String getTimeStamp() {
        return System.currentTimeMillis()+"";
    }

    /**
     * 两个时间的差值
     * @param time1 开始时间
     * @param time2 结束时间
     * @return 差值
     */
    public static long getTimeHSBetween(String time1, String time2) {
        SimpleDateFormat dfs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        long between = 0;
        try {
            java.util.Date begin = dfs.parse(time1);
            java.util.Date end = dfs.parse(time2);
            between = (end.getTime() - begin.getTime());// 得到两者的毫秒数
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return between;
    }
}
