package com.tts.android.aopmonitor;

import android.content.Context;
import android.content.Intent;

import android.os.Build;
import com.google.gson.Gson;
import com.tts.android.aopmonitor.aspect.ClickRecordAspect;
import com.tts.android.aopmonitor.bean.InitRecordBean;
import com.tts.android.aopmonitor.net.NetManager;
import com.tts.android.aopmonitor.net.bean.RecordRequestBean;
import com.tts.android.aopmonitor.options.MoniterOption;
import com.tts.android.aopmonitor.tools.Constants;
import com.tts.android.aopmonitor.tools.CtwUtils;
import com.tts.android.aopmonitor.tools.LogUtils;
import com.tts.android.aopmonitor.tools.StringUtils;

import static com.tts.android.aopmonitor.RecordService.initBaseRecordBean;

/**
 * AOPMonitor初始化与基本配置类
 * @author shijianting
 */
public class AOPMonitor {

    public static Context mContext;

    /**
     * 初始化
     * @param context application的引用
     */
    public static void init(Context context) {
        mContext = context.getApplicationContext();
        Constants.appContext = mContext;
        //生成本次操作流程唯一码
        Constants.random32String = StringUtils.getRandomString(32);
        LogUtils.initLogger();
    }


    /**
     * init with AOPOptions
     * @param context
     * @param options
     */
    public static void init(Context context, AOPOptions options) {
        init(context);
        Constants.options = options;
    }

    /**
     * set debug swtich
     * @param debug
     */
    public static void setDebug(boolean debug) {
        if (Constants.options != null) {
            Constants.options.setDebug(debug);
        }
    }

    /**
     * 配置首次发送的数据
     * 请在监控服务启动前配置
     * the method is deprecated
     * the current version of AOPMonitor do not need init data.
     * @param bean 数据对象
     * @param <T> 数据类型，继承InitRecordBean
     */
    @Deprecated
    public static <T extends InitRecordBean> void initRecordData(T bean) {
        if (bean instanceof  InitRecordBean) {
            Constants.initRecord = new Gson().toJson(CtwUtils.initCtwRecordBean(bean));
        }
    }



    /**
     * 设置主配置
     * @param options
     */
    public static void setOption(AOPOptions options) {
        Constants.options = options;
    }

    /**
     * 设置监控配置
     * @param option
     */
    public static void setMonitorOption(MoniterOption option) {
        Constants.moniterOption = option;
    }


    /**
     * start monitor service
     */
    public static void startRecordService() {
        if (null != mContext) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                mContext.startForegroundService(new Intent(mContext, RecordService.class));
            } else {
                mContext.startService(new Intent(mContext, RecordService.class));
            }
        }
    }

    /**
     * stop monitor service
     */
    public static void stopRecordService() {
        if (null != mContext) {
            Intent intent = new Intent(mContext, RecordService.class);
            mContext.stopService(intent);
        }
    }

    /**
     * set the monitor function is enabled
     * @param enabled
     */
    public static void setEnableMonitor(boolean enabled) {
        Constants.enabledMonitor = enabled;
    }

    /**
     * activity out record
     * @param context
     */
    public static void onDestroy(Context context) {

    }
}
