package com.tts.push;

import com.tts.push.bean.OnePageBean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 页面对应管理
 * @author shijianting
 * 2018/12/15 1:51 PM
 */
public class PageCenter {

    private static volatile PageCenter instance;

    public static PageCenter getInstance() {
        if (instance == null) {
            synchronized (PageCenter.class) {
                if (instance == null) {
                    instance = new PageCenter();
                    mPages = new HashMap<>();
                }
            }
        }
        return instance;

    }

    public static HashMap<String, OnePageBean> mPages;

    public void addPage(OnePageBean page) {
        if (null != mPages) {
            mPages.put(page.getUrl(), page);
        }
    }

    public void addPage(String name, Class cls) {
        OnePageBean bean = new OnePageBean();
        bean.setUrl(name);
        bean.setAct(cls);
        mPages.put(bean.getUrl(), bean);
    }

}
