package com.tts.android.aopmonitor.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 控件监控注解
 * @author shijianting
 * 2018/10/23 9:16 AM
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface BindMonitor {

    /**
     * View类型参数的位置
     * @return 参数位置
     */
    int viewPosition() default 0;

    /**
     * 如果拓展数据存在参数中，配置这个位置为拓展参数的位置
     * @return -1为没有这个参数
     */
    int extendPosition() default -1;

    /**
     * 手动设置控件id，可适用于集合类控件的id设置或者xml中忘记配置控件id的情况。
     * @return
     */
    String widgetId() default "";

    /**
     * 拓展数据
     * 如果view中的参数无法满足需求，请配置这个参数
     * 设置此参数，将会体现在请求中的extend参数上
     * @return 拓展数据
     */
    String extend() default "";

    /**
     * 是否启用重复点击控制
     * @return 开关
     */
    boolean multiClickLimit() default false;
}
