/*
 * Decompiled with CFR 0.152.
 */
package com.tt.calendarpageview.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class CalendarUtil {
    public static long getSystemTime() {
        return System.currentTimeMillis();
    }

    public static int[] getTimeFields(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int[] timeFields = new int[]{calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13)};
        return timeFields;
    }

    public static String getFormatTime(String formatter, long time) {
        SimpleDateFormat format = new SimpleDateFormat(formatter, Locale.getDefault());
        return format.format(new Date(time));
    }

    public static boolean isToday(long time) {
        int[] timeFields;
        long now = CalendarUtil.getSystemTime();
        int[] nowFields = CalendarUtil.getTimeFields(now);
        return nowFields[0] == (timeFields = CalendarUtil.getTimeFields(time))[0] && nowFields[1] == timeFields[1] && nowFields[2] == timeFields[2];
    }

    public static boolean isToday(Calendar time) {
        int[] timeFields;
        long now = CalendarUtil.getSystemTime();
        int[] nowFields = CalendarUtil.getTimeFields(now);
        return nowFields[0] == (timeFields = CalendarUtil.getTimeFields(time.getTimeInMillis()))[0] && nowFields[1] == timeFields[1] && nowFields[2] == timeFields[2];
    }

    public static boolean isSameDay(Calendar fromCalendar, Calendar toCalendar) {
        if (fromCalendar == null || toCalendar == null) {
            return false;
        }
        return fromCalendar.get(1) == toCalendar.get(1) && fromCalendar.get(2) == toCalendar.get(2) && fromCalendar.get(5) == toCalendar.get(5);
    }

    public static boolean isSameMonth(Calendar fromCalendar, Calendar toCalendar) {
        if (fromCalendar == null || toCalendar == null) {
            return false;
        }
        return fromCalendar.get(1) == toCalendar.get(1) && fromCalendar.get(2) == toCalendar.get(2);
    }

    public static String getAllFormatTime(long time) {
        return CalendarUtil.getFormatTime("yyyy-MM-dd HH:mm:ss", time);
    }

    public static String getYMDHMFormatTime(long time) {
        return CalendarUtil.getFormatTime("yyyy/MM/dd HH:mm", time);
    }

    public static String getHMFormatTime(long time) {
        return CalendarUtil.getFormatTime("HH:mm", time);
    }

    public static String getYMDFormatTime(long time) {
        return CalendarUtil.getFormatTime("yyyy/MM/dd", time);
    }

    public static String getHMSFormatTime(long time) {
        return CalendarUtil.getFormatTime("HH\u65f6mm\u5206ss\u79d2", time);
    }
}

