/*
 * Decompiled with CFR 0.152.
 */
package com.tt.calendarpageview.support;

import android.content.Context;
import android.content.res.TypedArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.tt.calendarpageview.R;
import com.tt.calendarpageview.support.CalendarItem;
import com.tt.calendarpageview.support.OnDaySelectedChangedListener;
import com.tt.calendarpageview.utils.CalendarUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class CalendarMonthAdapter
extends BaseAdapter {
    private OnDaySelectedChangedListener mOnDaySelectListener;
    private List<CalendarItem> mCalendarItems = new ArrayList<CalendarItem>();
    private Calendar mSelectedCal;
    private LayoutInflater mInflater;
    private Context mContext;
    private int mTodayTextStyle = R.style.textView_sp12_green;
    private int mNotCurrentTextStyle = R.style.textView_sp12_grey_light;
    private int mDayTextStyle = R.style.textView_sp12_white;
    private int mDaySelector = R.drawable.widget_item_calendar_cardview_selector;

    public CalendarMonthAdapter(Context context, TypedArray typedArray, Calendar selectedCal, List<CalendarItem> calendarItems) {
        this.mContext = context;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mSelectedCal = selectedCal;
        this.mCalendarItems = calendarItems;
        this.initStyle(typedArray);
    }

    public void initStyle(TypedArray typedArray) {
        if (typedArray != null) {
            this.mTodayTextStyle = typedArray.getResourceId(R.styleable.TtCalendar_todayTextStyle, R.style.textView_sp12_green);
            this.mNotCurrentTextStyle = typedArray.getResourceId(R.styleable.TtCalendar_notCurrentTextStyle, R.style.textView_sp12_grey_light);
            this.mDayTextStyle = typedArray.getResourceId(R.styleable.TtCalendar_dayTextStyle, R.style.textView_sp12_white);
            this.mDaySelector = typedArray.getResourceId(R.styleable.TtCalendar_daySelector, R.drawable.widget_item_calendar_cardview_selector);
            typedArray.recycle();
        }
    }

    public int getCount() {
        if (this.mCalendarItems == null || this.mCalendarItems.isEmpty()) {
            return 0;
        }
        return this.mCalendarItems.size();
    }

    public CalendarItem getItem(int position) {
        if (this.mCalendarItems == null || this.mCalendarItems.isEmpty()) {
            return null;
        }
        return this.mCalendarItems.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        GridViewHolder holder;
        if (convertView == null) {
            holder = new GridViewHolder();
            convertView = this.mInflater.inflate(R.layout.widget_item_calendar_cardview, parent, false);
            holder.tvDay = (TextView)convertView.findViewById(R.id.widget_item_calendar_cardview_date);
            convertView.setTag((Object)holder);
        } else {
            holder = (GridViewHolder)convertView.getTag();
        }
        final CalendarItem calendarItem = this.getItem(position);
        TextView tvDay = holder.tvDay;
        tvDay.setText((CharSequence)String.valueOf(calendarItem.calendar.get(5)));
        tvDay.setTextAppearance(this.mContext, this.getTextStyle(calendarItem));
        tvDay.setBackgroundResource(this.mDaySelector);
        tvDay.setSelected(CalendarUtil.isSameDay(this.mSelectedCal, calendarItem.calendar));
        tvDay.setEnabled(calendarItem.monthPos == 0);
        tvDay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CalendarMonthAdapter.this.checkItem(calendarItem.calendar);
            }
        });
        return convertView;
    }

    private void checkItem(Calendar cal) {
        if (CalendarUtil.isSameDay(cal, this.mSelectedCal)) {
            return;
        }
        this.mSelectedCal = (Calendar)cal.clone();
        this.notifyDataSetChanged();
        if (this.mOnDaySelectListener != null) {
            this.mOnDaySelectListener.onDaySelectedChanged(this.mSelectedCal);
        }
    }

    private int getTextStyle(CalendarItem calendarItem) {
        int style2 = calendarItem.monthPos == 0 ? (calendarItem.isToday ? this.mTodayTextStyle : this.mDayTextStyle) : this.mNotCurrentTextStyle;
        return style2;
    }

    public void setOnDaySelectListener(OnDaySelectedChangedListener onDaySelectListener) {
        this.mOnDaySelectListener = onDaySelectListener;
    }

    public List<CalendarItem> getDatas() {
        return this.mCalendarItems;
    }

    public void setDatas(List<CalendarItem> calendarItems) {
        this.mCalendarItems = calendarItems;
    }

    public void setSelectedDate(Calendar cal) {
        this.checkItem(cal);
    }

    public Calendar getSelectedDate() {
        return this.mSelectedCal;
    }

    public static class GridViewHolder {
        public TextView tvDay;
    }
}

