/*
 * Decompiled with CFR 0.152.
 */
package com.tt.calendarpageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.tt.calendarpageview.CalendarCardView;
import com.tt.calendarpageview.R;
import com.tt.calendarpageview.support.OnDaySelectedChangedListener;
import java.util.Calendar;

public class CalendarPageView
extends LinearLayout {
    private Context mContext;
    private CalendarCardView mCalendarCardView;

    public CalendarPageView(Context context) {
        this(context, null);
    }

    public CalendarPageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        int weekTextStyle;
        TypedArray typedArray = null;
        if (attrs != null) {
            typedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.TtCalendar);
            weekTextStyle = typedArray.getResourceId(R.styleable.TtCalendar_weekTextStyle, R.style.textView_sp12_green);
        } else {
            weekTextStyle = R.style.textView_sp13_grey_bg_bold;
        }
        CalendarPageView.inflate((Context)this.mContext, (int)R.layout.widget_calendar_pageview, (ViewGroup)this);
        this.setGravity(1);
        this.setOrientation(1);
        LinearLayout weekdaysLl = (LinearLayout)this.findViewById(R.id.widget_calendar_card_weekdays);
        for (int i = 0; i < weekdaysLl.getChildCount(); ++i) {
            View child = weekdaysLl.getChildAt(i);
            if (!(child instanceof TextView)) continue;
            ((TextView)child).setTextAppearance(this.mContext, weekTextStyle);
        }
        this.mCalendarCardView = (CalendarCardView)this.findViewById(R.id.widget_calendar_pageview_card);
        this.mCalendarCardView.setTypedArray(typedArray);
    }

    public void setCurrentMonth(Calendar currentMonth) {
        this.mCalendarCardView.setCurrentMonth(currentMonth);
    }

    public void selectCal(Calendar selectedCal) {
        this.mCalendarCardView.selectCal(selectedCal);
    }

    public void setOnDaySelectListener(OnDaySelectedChangedListener onDaySelectListener) {
        this.mCalendarCardView.setOnDaySelectListener(onDaySelectListener);
    }
}

