/*
 * Decompiled with CFR 0.152.
 */
package com.tt.calendarpageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.ListAdapter;
import com.tt.calendarpageview.R;
import com.tt.calendarpageview.support.CalendarItem;
import com.tt.calendarpageview.support.CalendarMonthAdapter;
import com.tt.calendarpageview.support.GridWithoutScrollView;
import com.tt.calendarpageview.support.OnDaySelectedChangedListener;
import com.tt.calendarpageview.utils.CalendarUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class CalendarCardView
extends GridWithoutScrollView {
    private Context mContext;
    private CalendarMonthAdapter mGridViewAdapter;
    private Calendar mCurrentMonth = Calendar.getInstance();
    private OnDaySelectedChangedListener mOnDaySelectListener;
    private TypedArray mTypedArray;

    public CalendarCardView(Context context) {
        this(context, null);
    }

    public CalendarCardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            this.mTypedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.TtCalendar);
        }
        this.setGravity(1);
        this.setSelector(R.color.transparent);
        this.setNumColumns(7);
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        this.setStretchMode(2);
        this.mGridViewAdapter = new CalendarMonthAdapter(this.mContext, this.mTypedArray, Calendar.getInstance(), this.getGvDataByYearAndMonth());
        this.mGridViewAdapter.setOnDaySelectListener(new OnDaySelectedChangedListener(){

            @Override
            public void onDaySelectedChanged(Calendar dateSelected) {
                if (CalendarCardView.this.mOnDaySelectListener != null) {
                    CalendarCardView.this.mOnDaySelectListener.onDaySelectedChanged(dateSelected);
                }
            }
        });
        this.setAdapter((ListAdapter)this.mGridViewAdapter);
    }

    public TypedArray getTypedArray() {
        return this.mTypedArray;
    }

    public void setTypedArray(TypedArray mTypedArray) {
        this.mTypedArray = mTypedArray;
        this.mGridViewAdapter.initStyle(mTypedArray);
    }

    public void setCurrentMonth(Calendar currentMonth) {
        this.mCurrentMonth = (Calendar)currentMonth.clone();
        this.notifyMonthChanged();
    }

    private void notifyMonthChanged() {
        this.mGridViewAdapter.setDatas(this.getGvDataByYearAndMonth());
        this.mGridViewAdapter.notifyDataSetChanged();
    }

    public void selectCal(Calendar selectedCal) {
        this.mGridViewAdapter.setSelectedDate(selectedCal);
        this.mGridViewAdapter.notifyDataSetChanged();
    }

    private List<CalendarItem> getGvDataByYearAndMonth() {
        int firstDaySpaceCount = CalendarCardView.getFirstDayOfSpaceCount(this.mCurrentMonth);
        int lastDaySpaceCount = CalendarCardView.getLastDayOfSpaceCount(this.mCurrentMonth);
        int dayCount = CalendarCardView.getDayNumInMonth(this.mCurrentMonth);
        return this.getGvListData(firstDaySpaceCount, lastDaySpaceCount, dayCount);
    }

    private List<CalendarItem> getGvListData(int first, int last, int dayCount) {
        Calendar calendar;
        CalendarItem calendarItem;
        ArrayList<CalendarItem> list = new ArrayList<CalendarItem>();
        Calendar currentCalendar = (Calendar)this.mCurrentMonth.clone();
        currentCalendar.set(5, 1);
        for (int i = 0; i < first; ++i) {
            calendarItem = new CalendarItem();
            calendar = (Calendar)currentCalendar.clone();
            calendar.add(2, -1);
            calendar.set(5, CalendarCardView.getDayNumInMonth(calendar) - first + i + 1);
            calendarItem.calendar = calendar;
            calendarItem.isToday = CalendarUtil.isToday(calendar);
            calendarItem.monthPos = 1;
            list.add(calendarItem);
        }
        for (int j = 0; j < dayCount; ++j) {
            calendarItem = new CalendarItem();
            calendar = (Calendar)currentCalendar.clone();
            calendar.set(5, j + 1);
            calendarItem.calendar = calendar;
            calendarItem.isToday = CalendarUtil.isToday(calendar);
            calendarItem.monthPos = 0;
            list.add(calendarItem);
        }
        for (int k = 0; k < last; ++k) {
            calendarItem = new CalendarItem();
            calendar = (Calendar)currentCalendar.clone();
            calendar.add(2, 1);
            calendar.set(5, k + 1);
            calendarItem.calendar = calendar;
            calendarItem.isToday = CalendarUtil.isToday(calendar);
            calendarItem.monthPos = 2;
            list.add(calendarItem);
        }
        return list;
    }

    private static int getFirstDayOfSpaceCount(Calendar cal) {
        Calendar calTemp = (Calendar)cal.clone();
        calTemp.set(5, 1);
        int firstDayInWeek = calTemp.get(7);
        return CalendarCardView.weekToSpaceCount(firstDayInWeek);
    }

    private static int getLastDayOfSpaceCount(Calendar cal) {
        Calendar calTemp = (Calendar)cal.clone();
        calTemp.set(5, CalendarCardView.getDayNumInMonth(cal));
        int lastDayInWeek = calTemp.get(7);
        return 6 - CalendarCardView.weekToSpaceCount(lastDayInWeek);
    }

    private static int weekToSpaceCount(int week) {
        int space = (7 + (week - 2)) % 7;
        return space;
    }

    private static int getDayNumInMonth(Calendar cal) {
        return cal.getActualMaximum(5);
    }

    public OnDaySelectedChangedListener getOnDaySelectListener() {
        return this.mOnDaySelectListener;
    }

    public void setOnDaySelectListener(OnDaySelectedChangedListener mOnDaySelectListener) {
        this.mOnDaySelectListener = mOnDaySelectListener;
    }
}

