/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import org.bytedeco.javacv.FFmpegFrameFilter;
import org.bytedeco.javacv.Frame;

public abstract class FrameFilter {
    protected String filters;
    protected int imageWidth;
    protected int imageHeight;
    protected int pixelFormat;
    protected double frameRate;
    protected double aspectRatio;

    public static FrameFilter createDefault(String filtersDescr, int imageWidth, int imageHeight) throws Exception {
        return new FFmpegFrameFilter(filtersDescr, imageWidth, imageHeight);
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public void setPixelFormat(int pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(double frameRate) {
        this.frameRate = frameRate;
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public void setAspectRatio(double aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    public abstract void push(Frame var1) throws Exception;

    public abstract Frame pull() throws Exception;

    public abstract void release() throws Exception;

    public void restart() throws Exception {
        this.stop();
        this.start();
    }

    public void flush() throws Exception {
        while (this.pull() != null) {
        }
    }

    public static class Exception
    extends java.lang.Exception {
        public Exception(String message) {
            super(message);
        }

        public Exception(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

