/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;

public class Frame
implements Indexable {
    public boolean keyFrame;
    public static final int DEPTH_BYTE = -8;
    public static final int DEPTH_UBYTE = 8;
    public static final int DEPTH_SHORT = -16;
    public static final int DEPTH_USHORT = 16;
    public static final int DEPTH_INT = -32;
    public static final int DEPTH_LONG = -64;
    public static final int DEPTH_FLOAT = 32;
    public static final int DEPTH_DOUBLE = 64;
    public int imageWidth;
    public int imageHeight;
    public int imageDepth;
    public int imageChannels;
    public int imageStride;
    public Buffer[] image;
    public int sampleRate;
    public int audioChannels;
    public Buffer[] samples;
    public Object opaque;

    public Frame() {
    }

    public Frame(int width, int height, int depth, int channels) {
        int pixelSize = Math.abs(depth) / 8;
        this.imageWidth = width;
        this.imageHeight = height;
        this.imageDepth = depth;
        this.imageChannels = channels;
        this.imageStride = (this.imageWidth * this.imageChannels * pixelSize + 7 & 0xFFFFFFF8) / pixelSize;
        this.image = new Buffer[1];
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.imageHeight * this.imageStride * pixelSize).order(ByteOrder.nativeOrder());
        switch (this.imageDepth) {
            case -8: 
            case 8: {
                this.image[0] = buffer;
                break;
            }
            case -16: 
            case 16: {
                this.image[0] = buffer.asShortBuffer();
                break;
            }
            case -32: {
                this.image[0] = buffer.asIntBuffer();
                break;
            }
            case -64: {
                this.image[0] = buffer.asLongBuffer();
                break;
            }
            case 32: {
                this.image[0] = buffer.asFloatBuffer();
                break;
            }
            case 64: {
                this.image[0] = buffer.asDoubleBuffer();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported depth value: " + this.imageDepth);
            }
        }
    }

    public <I extends Indexer> I createIndexer() {
        return this.createIndexer(true, 0);
    }

    public <I extends Indexer> I createIndexer(boolean direct) {
        return this.createIndexer(direct, 0);
    }

    public <I extends Indexer> I createIndexer(boolean direct, int i) {
        int[] sizes = new int[]{this.imageHeight, this.imageWidth, this.imageChannels};
        int[] strides = new int[]{this.imageStride, this.imageChannels, 1};
        Buffer buffer = this.image[i];
        Object array = buffer.hasArray() ? buffer.array() : null;
        switch (this.imageDepth) {
            case 8: {
                return (I)(array != null ? UByteIndexer.create((byte[])((byte[])array), (int[])sizes, (int[])strides) : (direct ? UByteIndexer.create((ByteBuffer)((ByteBuffer)buffer), (int[])sizes, (int[])strides) : UByteIndexer.create((BytePointer)new BytePointer((ByteBuffer)buffer), (int[])sizes, (int[])strides, (boolean)false)));
            }
            case -8: {
                return (I)(array != null ? ByteIndexer.create((byte[])((byte[])array), (int[])sizes, (int[])strides) : (direct ? ByteIndexer.create((ByteBuffer)((ByteBuffer)buffer), (int[])sizes, (int[])strides) : ByteIndexer.create((BytePointer)new BytePointer((ByteBuffer)buffer), (int[])sizes, (int[])strides, (boolean)false)));
            }
            case 16: {
                return (I)(array != null ? UShortIndexer.create((short[])((short[])array), (int[])sizes, (int[])strides) : (direct ? UShortIndexer.create((ShortBuffer)((ShortBuffer)buffer), (int[])sizes, (int[])strides) : UShortIndexer.create((ShortPointer)new ShortPointer((ShortBuffer)buffer), (int[])sizes, (int[])strides, (boolean)false)));
            }
            case -16: {
                return (I)(array != null ? ShortIndexer.create((short[])((short[])array), (int[])sizes, (int[])strides) : (direct ? ShortIndexer.create((ShortBuffer)((ShortBuffer)buffer), (int[])sizes, (int[])strides) : ShortIndexer.create((ShortPointer)new ShortPointer((ShortBuffer)buffer), (int[])sizes, (int[])strides, (boolean)false)));
            }
            case -32: {
                return (I)(array != null ? IntIndexer.create((int[])((int[])array), (int[])sizes, (int[])strides) : (direct ? IntIndexer.create((IntBuffer)((IntBuffer)buffer), (int[])sizes, (int[])strides) : IntIndexer.create((IntPointer)new IntPointer((IntBuffer)buffer), (int[])sizes, (int[])strides, (boolean)false)));
            }
            case -64: {
                return (I)(array != null ? LongIndexer.create((long[])((long[])array), (int[])sizes, (int[])strides) : (direct ? LongIndexer.create((LongBuffer)((LongBuffer)buffer), (int[])sizes, (int[])strides) : LongIndexer.create((LongPointer)new LongPointer((LongBuffer)buffer), (int[])sizes, (int[])strides, (boolean)false)));
            }
            case 32: {
                return (I)(array != null ? FloatIndexer.create((float[])((float[])array), (int[])sizes, (int[])strides) : (direct ? FloatIndexer.create((FloatBuffer)((FloatBuffer)buffer), (int[])sizes, (int[])strides) : FloatIndexer.create((FloatPointer)new FloatPointer((FloatBuffer)buffer), (int[])sizes, (int[])strides, (boolean)false)));
            }
            case 64: {
                return (I)(array != null ? DoubleIndexer.create((double[])((double[])array), (int[])sizes, (int[])strides) : (direct ? DoubleIndexer.create((DoubleBuffer)((DoubleBuffer)buffer), (int[])sizes, (int[])strides) : DoubleIndexer.create((DoublePointer)new DoublePointer((DoubleBuffer)buffer), (int[])sizes, (int[])strides, (boolean)false)));
            }
        }
        assert (false);
        return null;
    }
}

